rule win_rctrl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rctrl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rctrl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41 0024bf 41 00558b ec 81ec90000000 a1???????? }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   0024bf               | add                 byte ptr [edi + edi*4], ah
            //   41                   | inc                 ecx
            //   00558b               | add                 byte ptr [ebp - 0x75], dl
            //   ec                   | in                  al, dx
            //   81ec90000000         | sub                 esp, 0x90
            //   a1????????           |                     

        $sequence_1 = { e8???????? c3 83795c00 7405 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   c3                   | ret                 
            //   83795c00             | cmp                 dword ptr [ecx + 0x5c], 0
            //   7405                 | je                  7

        $sequence_2 = { 7507 32db e9???????? 6890010000 8d8564fcffff 6a00 50 }
            // n = 7, score = 100
            //   7507                 | jne                 9
            //   32db                 | xor                 bl, bl
            //   e9????????           |                     
            //   6890010000           | push                0x190
            //   8d8564fcffff         | lea                 eax, [ebp - 0x39c]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_3 = { e8???????? cc 55 8bec 837d0c00 57 8bf9 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx

        $sequence_4 = { 8b02 3b07 7536 52 e8???????? 83ceff 8985c8fbffff }
            // n = 7, score = 100
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   3b07                 | cmp                 eax, dword ptr [edi]
            //   7536                 | jne                 0x38
            //   52                   | push                edx
            //   e8????????           |                     
            //   83ceff               | or                  esi, 0xffffffff
            //   8985c8fbffff         | mov                 dword ptr [ebp - 0x438], eax

        $sequence_5 = { b801000000 833d????????00 0f8516710000 ba05000000 8d0dd0185a00 e8???????? 5a }
            // n = 7, score = 100
            //   b801000000           | mov                 eax, 1
            //   833d????????00       |                     
            //   0f8516710000         | jne                 0x711c
            //   ba05000000           | mov                 edx, 5
            //   8d0dd0185a00         | lea                 ecx, [0x5a18d0]
            //   e8????????           |                     
            //   5a                   | pop                 edx

        $sequence_6 = { ffb3780b0000 8d4d80 6a00 6a00 56 50 e8???????? }
            // n = 7, score = 100
            //   ffb3780b0000         | push                dword ptr [ebx + 0xb78]
            //   8d4d80               | lea                 ecx, [ebp - 0x80]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 8bc7 8b55cc 83c2f0 f00fc1420c 48 85c0 7f08 }
            // n = 7, score = 100
            //   8bc7                 | mov                 eax, edi
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   83c2f0               | add                 edx, -0x10
            //   f00fc1420c           | lock xadd           dword ptr [edx + 0xc], eax
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   7f08                 | jg                  0xa

        $sequence_8 = { 84c0 75f9 2bce 51 52 e8???????? 6a00 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   2bce                 | sub                 ecx, esi
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   6a00                 | push                0

        $sequence_9 = { e9???????? 8d8de0fcffff e9???????? 8d8de8fcffff e9???????? 8d8d00fdffff e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d8de0fcffff         | lea                 ecx, [ebp - 0x320]
            //   e9????????           |                     
            //   8d8de8fcffff         | lea                 ecx, [ebp - 0x318]
            //   e9????????           |                     
            //   8d8d00fdffff         | lea                 ecx, [ebp - 0x300]
            //   e9????????           |                     

    condition:
        7 of them and filesize < 4315136
}