rule win_rdat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rdat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rdat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8bc3 4c0f42c7 4d85c0 7504 }
            // n = 4, score = 300
            //   4c8bc3               | cmp                 dword ptr [ecx + 0x18], 0x10
            //   4c0f42c7             | dec                 eax
            //   4d85c0               | mov                 edi, dword ptr [ecx + 0x10]
            //   7504                 | jb                  5

        $sequence_1 = { 48897020 498bf8 488bda 488bf1 b920000000 }
            // n = 5, score = 300
            //   48897020             | cmp                 dword ptr [ecx + 0x18], 0x10
            //   498bf8               | dec                 eax
            //   488bda               | mov                 edi, dword ptr [ecx + 0x10]
            //   488bf1               | jb                  0x14
            //   b920000000           | dec                 eax

        $sequence_2 = { 0f8d9e000000 488b4660 3b5668 7c1d }
            // n = 4, score = 300
            //   0f8d9e000000         | dec                 eax
            //   488b4660             | mov                 ecx, dword ptr [ecx]
            //   3b5668               | jmp                 7
            //   7c1d                 | dec                 eax

        $sequence_3 = { 0f8d83000000 488b82b0000000 443b82b8000000 7c25 442b82b8000000 48638ab8000000 488b7cc8f8 }
            // n = 7, score = 300
            //   0f8d83000000         | dec                 ebp
            //   488b82b0000000       | test                eax, eax
            //   443b82b8000000       | dec                 eax
            //   7c25                 | mov                 ecx, dword ptr [ecx]
            //   442b82b8000000       | dec                 eax
            //   48638ab8000000       | cmp                 edi, ebx
            //   488b7cc8f8           | dec                 esp

        $sequence_4 = { 4533c9 488bfa 4c8bc1 85db 7e77 }
            // n = 5, score = 300
            //   4533c9               | dec                 eax
            //   488bfa               | mov                 edi, dword ptr [ecx + 0x10]
            //   4c8bc1               | jb                  9
            //   85db                 | dec                 eax
            //   7e77                 | mov                 ecx, dword ptr [ecx]

        $sequence_5 = { 4889742410 57 4883ec20 488b02 488bf1 488bfa 488b18 }
            // n = 7, score = 300
            //   4889742410           | dec                 eax
            //   57                   | mov                 edi, dword ptr [ecx + 0x10]
            //   4883ec20             | jb                  5
            //   488b02               | dec                 eax
            //   488bf1               | mov                 ecx, dword ptr [ecx]
            //   488bfa               | dec                 eax
            //   488b18               | cmp                 edi, ebx

        $sequence_6 = { 0f85a8000000 83791804 0f859e000000 8b4920 }
            // n = 4, score = 300
            //   0f85a8000000         | test                eax, eax
            //   83791804             | jne                 9
            //   0f859e000000         | mov                 eax, esi
            //   8b4920               | dec                 eax

        $sequence_7 = { 6690 48ffc3 4038341a 75f7 4883791810 488b7910 7203 }
            // n = 7, score = 300
            //   6690                 | nop                 
            //   48ffc3               | dec                 eax
            //   4038341a             | inc                 ebx
            //   75f7                 | inc                 eax
            //   4883791810           | cmp                 byte ptr [edx + ebx], dh
            //   488b7910             | jne                 0xfffffff9
            //   7203                 | dec                 eax

        $sequence_8 = { 85c0 740b b9e8030000 ff15???????? }
            // n = 4, score = 300
            //   85c0                 | dec                 eax
            //   740b                 | mov                 edi, dword ptr [ecx + 0x10]
            //   b9e8030000           | jb                  0x10
            //   ff15????????         |                     

        $sequence_9 = { e8???????? 4898 4885c0 751e 483bfb 7313 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   4898                 | dec                 eax
            //   4885c0               | or                  ebx, 0xffffffff
            //   751e                 | nop                 
            //   483bfb               | dec                 eax
            //   7313                 | inc                 ebx

        $sequence_10 = { 4883ec40 48c740d8feffffff 48895808 48897020 }
            // n = 4, score = 300
            //   4883ec40             | dec                 eax
            //   48c740d8feffffff     | cmp                 edi, ebx
            //   48895808             | dec                 esp
            //   48897020             | mov                 eax, ebx

        $sequence_11 = { 0f8d89000000 496398b8000000 498b80b0000000 3bd3 }
            // n = 4, score = 300
            //   0f8d89000000         | mov                 eax, ebx
            //   496398b8000000       | dec                 esp
            //   498b80b0000000       | cmovb               eax, edi
            //   3bd3                 | dec                 ebp

        $sequence_12 = { 488b7910 7203 488b09 483bfb 4c8bc3 4c0f42c7 }
            // n = 6, score = 300
            //   488b7910             | dec                 eax
            //   7203                 | cwde                
            //   488b09               | dec                 eax
            //   483bfb               | test                eax, eax
            //   4c8bc3               | jne                 0x25
            //   4c0f42c7             | dec                 eax

        $sequence_13 = { 486bd158 490314c0 eb07 488d15f6a30100 f6420820 7417 }
            // n = 6, score = 100
            //   486bd158             | dec                 eax
            //   490314c0             | test                eax, eax
            //   eb07                 | jne                 0x20
            //   488d15f6a30100       | dec                 eax
            //   f6420820             | cmp                 edi, ebx
            //   7417                 | jae                 0x15

        $sequence_14 = { 41b803000000 498b17 488d4d90 e8???????? 90 }
            // n = 5, score = 100
            //   41b803000000         | dec                 esp
            //   498b17               | cmovb               eax, edi
            //   488d4d90             | dec                 eax
            //   e8????????           |                     
            //   90                   | cwde                

        $sequence_15 = { 90 48c78424b80000000f000000 4c89b424b0000000 c68424a000000000 4983c9ff 4533c0 488d942470030000 }
            // n = 7, score = 100
            //   90                   | jb                  9
            //   48c78424b80000000f000000     | dec    eax
            //   4c89b424b0000000     | mov                 ecx, dword ptr [ecx]
            //   c68424a000000000     | dec                 eax
            //   4983c9ff             | cmp                 edi, ebx
            //   4533c0               | dec                 esp
            //   488d942470030000     | mov                 eax, ebx

    condition:
        7 of them and filesize < 1573888
}