rule win_reactorbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.reactorbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.reactorbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4804 894dfc 8b55fc a1???????? }
            // n = 4, score = 900
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   a1????????           |                     

        $sequence_1 = { c745e400000000 a1???????? 8945e0 8b4d08 }
            // n = 4, score = 900
            //   c745e400000000       | mov                 dword ptr [ebp - 0x1c], 0
            //   a1????????           |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_2 = { 50 ff15???????? 8b55f4 52 ff15???????? 8b45ec 8be5 }
            // n = 7, score = 900
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8be5                 | mov                 esp, ebp

        $sequence_3 = { ff15???????? 8945f8 837df800 7449 8b55fc 52 }
            // n = 6, score = 900
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7449                 | je                  0x4b
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx

        $sequence_4 = { 8d8590fdffff 50 ff15???????? 8d8d90fdffff 51 }
            // n = 5, score = 900
            //   8d8590fdffff         | lea                 eax, [ebp - 0x270]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d8d90fdffff         | lea                 ecx, [ebp - 0x270]
            //   51                   | push                ecx

        $sequence_5 = { 8d9580f9ffff 52 ff15???????? 8945ec 837decff }
            // n = 5, score = 900
            //   8d9580f9ffff         | lea                 edx, [ebp - 0x680]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   837decff             | cmp                 dword ptr [ebp - 0x14], -1

        $sequence_6 = { a1???????? 8982b8000000 83c8ff 8be5 }
            // n = 4, score = 900
            //   a1????????           |                     
            //   8982b8000000         | mov                 dword ptr [edx + 0xb8], eax
            //   83c8ff               | or                  eax, 0xffffffff
            //   8be5                 | mov                 esp, ebp

        $sequence_7 = { 8b4508 50 6804010000 8d8d78f7ffff 51 e8???????? 8d9578f7ffff }
            // n = 7, score = 900
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   8d8d78f7ffff         | lea                 ecx, [ebp - 0x888]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d9578f7ffff         | lea                 edx, [ebp - 0x888]

        $sequence_8 = { 7402 eb0c c705????????b80b0000 eb0a c705????????e8030000 }
            // n = 5, score = 400
            //   7402                 | je                  4
            //   eb0c                 | jmp                 0xe
            //   c705????????b80b0000     |     
            //   eb0a                 | jmp                 0xc
            //   c705????????e8030000     |     

        $sequence_9 = { ff15???????? e8???????? 833d????????00 7509 833d????????00 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7509                 | jne                 0xb
            //   833d????????00       |                     

        $sequence_10 = { 83c005 99 b905000000 f7f9 }
            // n = 4, score = 400
            //   83c005               | add                 eax, 5
            //   99                   | cdq                 
            //   b905000000           | mov                 ecx, 5
            //   f7f9                 | idiv                ecx

        $sequence_11 = { 69c0b13a0200 99 83e203 03c2 }
            // n = 4, score = 400
            //   69c0b13a0200         | imul                eax, eax, 0x23ab1
            //   99                   | cdq                 
            //   83e203               | and                 edx, 3
            //   03c2                 | add                 eax, edx

        $sequence_12 = { 6bc005 83e803 99 b999000000 f7f9 }
            // n = 5, score = 400
            //   6bc005               | imul                eax, eax, 5
            //   83e803               | sub                 eax, 3
            //   99                   | cdq                 
            //   b999000000           | mov                 ecx, 0x99
            //   f7f9                 | idiv                ecx

        $sequence_13 = { 83e101 f7d9 81e12083b8ed 33c1 }
            // n = 4, score = 400
            //   83e101               | and                 ecx, 1
            //   f7d9                 | neg                 ecx
            //   81e12083b8ed         | and                 ecx, 0xedb88320
            //   33c1                 | xor                 eax, ecx

        $sequence_14 = { 837c246000 0f8562010000 c744245400000000 c744247400100000 }
            // n = 4, score = 200
            //   837c246000           | mov                 eax, 4
            //   0f8562010000         | dec                 eax
            //   c744245400000000     | lea                 edx, [0x7eed]
            //   c744247400100000     | dec                 eax

        $sequence_15 = { 48837c245000 0f8417040000 4c8d0da2b30000 41b804000000 488d15ed7e0000 488b4c2450 }
            // n = 6, score = 200
            //   48837c245000         | dec                 eax
            //   0f8417040000         | cmp                 dword ptr [esp + 0x50], 0
            //   4c8d0da2b30000       | je                  0x41d
            //   41b804000000         | dec                 esp
            //   488d15ed7e0000       | lea                 ecx, [0xb3a2]
            //   488b4c2450           | inc                 ecx

    condition:
        7 of them and filesize < 1032192
}