rule win_reaver_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.reaver."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.reaver"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3d14050000 7504 33c0 c9 c3 }
            // n = 5, score = 900
            //   3d14050000           | cmp                 eax, 0x514
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_1 = { 7453 8d45f4 50 ff7508 6a00 ff15???????? }
            // n = 6, score = 900
            //   7453                 | je                  0x55
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_2 = { ff15???????? 85c0 7440 8b45f4 6a00 }
            // n = 5, score = 900
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7440                 | je                  0x42
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   6a00                 | push                0

        $sequence_3 = { ff15???????? 85c0 7453 8d45f4 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7453                 | je                  0x55
            //   8d45f4               | lea                 eax, [ebp - 0xc]

        $sequence_4 = { 50 ff15???????? 85c0 7453 8d45f4 50 ff7508 }
            // n = 7, score = 900
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7453                 | je                  0x55
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_5 = { ff15???????? 85c0 740d ff15???????? 3d14050000 7504 33c0 }
            // n = 7, score = 900
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   ff15????????         |                     
            //   3d14050000           | cmp                 eax, 0x514
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 85c0 7453 8d45f4 50 ff7508 }
            // n = 5, score = 900
            //   85c0                 | test                eax, eax
            //   7453                 | je                  0x55
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_7 = { 50 ff7508 6a00 ff15???????? 85c0 7440 }
            // n = 6, score = 900
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7440                 | je                  0x42

        $sequence_8 = { 6a00 ff15???????? 85c0 7440 8b45f4 6a00 }
            // n = 6, score = 900
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7440                 | je                  0x42
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   6a00                 | push                0

        $sequence_9 = { 50 c6467430 e8???????? 83c634 }
            // n = 4, score = 900
            //   50                   | push                eax
            //   c6467430             | mov                 byte ptr [esi + 0x74], 0x30
            //   e8????????           |                     
            //   83c634               | add                 esi, 0x34

    condition:
        7 of them and filesize < 106496
}