rule win_redsalt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.redsalt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redsalt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c414 33c9 83f8ff 0f95c1 }
            // n = 4, score = 1100
            //   83c414               | add                 esp, 0x14
            //   33c9                 | xor                 ecx, ecx
            //   83f8ff               | cmp                 eax, -1
            //   0f95c1               | setne               cl

        $sequence_1 = { 750b 68e8030000 ff15???????? e8???????? }
            // n = 4, score = 1100
            //   750b                 | jne                 0xd
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     
            //   e8????????           |                     

        $sequence_2 = { 51 ffd6 85c0 7510 }
            // n = 4, score = 900
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12

        $sequence_3 = { c745d060ea0000 6a04 8d45d0 50 6806100000 68ffff0000 }
            // n = 6, score = 900
            //   c745d060ea0000       | mov                 dword ptr [ebp - 0x30], 0xea60
            //   6a04                 | push                4
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   6806100000           | push                0x1006
            //   68ffff0000           | push                0xffff

        $sequence_4 = { e8???????? 85c0 750a 6a32 }
            // n = 4, score = 900
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   6a32                 | push                0x32

        $sequence_5 = { 85c0 7515 c705????????01000000 ff15???????? e9???????? }
            // n = 5, score = 900
            //   85c0                 | test                eax, eax
            //   7515                 | jne                 0x17
            //   c705????????01000000     |     
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_6 = { 740d 68???????? e8???????? 83c404 833d????????02 }
            // n = 5, score = 800
            //   740d                 | je                  0xf
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   833d????????02       |                     

        $sequence_7 = { 83c9ff 85f6 7c0e 83fe7f 7f09 }
            // n = 5, score = 800
            //   83c9ff               | or                  ecx, 0xffffffff
            //   85f6                 | test                esi, esi
            //   7c0e                 | jl                  0x10
            //   83fe7f               | cmp                 esi, 0x7f
            //   7f09                 | jg                  0xb

        $sequence_8 = { 6a00 52 c744242401000000 8944242c c744243002000000 }
            // n = 5, score = 700
            //   6a00                 | push                0
            //   52                   | push                edx
            //   c744242401000000     | mov                 dword ptr [esp + 0x24], 1
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax
            //   c744243002000000     | mov                 dword ptr [esp + 0x30], 2

        $sequence_9 = { 7509 80780120 7503 83c002 }
            // n = 4, score = 700
            //   7509                 | jne                 0xb
            //   80780120             | cmp                 byte ptr [eax + 1], 0x20
            //   7503                 | jne                 5
            //   83c002               | add                 eax, 2

        $sequence_10 = { 83c40c eb02 33c0 8b4df4 }
            // n = 4, score = 700
            //   83c40c               | add                 esp, 0xc
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_11 = { c60100 5f 5e 33c0 }
            // n = 4, score = 700
            //   c60100               | mov                 byte ptr [ecx], 0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_12 = { 8d8530fcffff 50 e8???????? 83c40c }
            // n = 4, score = 700
            //   8d8530fcffff         | lea                 eax, [ebp - 0x3d0]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_13 = { e8???????? 83c408 6800010000 68???????? }
            // n = 4, score = 600
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6800010000           | push                0x100
            //   68????????           |                     

        $sequence_14 = { c6450000 5e 5d 8911 33c0 }
            // n = 5, score = 500
            //   c6450000             | mov                 byte ptr [ebp], 0
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   8911                 | mov                 dword ptr [ecx], edx
            //   33c0                 | xor                 eax, eax

        $sequence_15 = { f7e7 8bea d1ed 33c0 83ef03 8a06 }
            // n = 6, score = 500
            //   f7e7                 | mul                 edi
            //   8bea                 | mov                 ebp, edx
            //   d1ed                 | shr                 ebp, 1
            //   33c0                 | xor                 eax, eax
            //   83ef03               | sub                 edi, 3
            //   8a06                 | mov                 al, byte ptr [esi]

        $sequence_16 = { c1fa04 c0e302 0ad3 83c004 }
            // n = 4, score = 500
            //   c1fa04               | sar                 edx, 4
            //   c0e302               | shl                 bl, 2
            //   0ad3                 | or                  dl, bl
            //   83c004               | add                 eax, 4

        $sequence_17 = { 833800 750f c705????????01000000 e9???????? }
            // n = 4, score = 500
            //   833800               | cmp                 dword ptr [eax], 0
            //   750f                 | jne                 0x11
            //   c705????????01000000     |     
            //   e9????????           |                     

        $sequence_18 = { c644243423 c644243572 c64424367a c644243700 }
            // n = 4, score = 300
            //   c644243423           | mov                 byte ptr [esp + 0x34], 0x23
            //   c644243572           | mov                 byte ptr [esp + 0x35], 0x72
            //   c64424367a           | mov                 byte ptr [esp + 0x36], 0x7a
            //   c644243700           | mov                 byte ptr [esp + 0x37], 0

        $sequence_19 = { d2cc bbe3b46b7e 6aa2 dd45ff }
            // n = 4, score = 200
            //   d2cc                 | ror                 ah, cl
            //   bbe3b46b7e           | mov                 ebx, 0x7e6bb4e3
            //   6aa2                 | push                -0x5e
            //   dd45ff               | fld                 qword ptr [ebp - 1]

        $sequence_20 = { de6c58ae c8201cdd f7be5b408d58 1b7f01 d2cc }
            // n = 5, score = 200
            //   de6c58ae             | fisubr              word ptr [eax + ebx*2 - 0x52]
            //   c8201cdd             | enter               0x1c20, -0x23
            //   f7be5b408d58         | idiv                dword ptr [esi + 0x588d405b]
            //   1b7f01               | sbb                 edi, dword ptr [edi + 1]
            //   d2cc                 | ror                 ah, cl

        $sequence_21 = { e8???????? 89ff 152edf0800 488b5c2440 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89ff                 | dec                 ecx
            //   152edf0800           | mov                 eax, ebx
            //   488b5c2440           | dec                 eax

        $sequence_22 = { e8???????? 89fa 4989d8 4889c1 e8???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   89fa                 | mov                 edx, edi
            //   4989d8               | dec                 ecx
            //   4889c1               | mov                 eax, ebx
            //   e8????????           |                     

        $sequence_23 = { e8???????? 89f8 eb26 f6411840 7406 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   89f8                 | mov                 eax, edi
            //   eb26                 | jmp                 0x28
            //   f6411840             | test                byte ptr [ecx + 0x18], 0x40
            //   7406                 | je                  8

        $sequence_24 = { e8???????? 8b05???????? 0d80000000 8905???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8b05????????         |                     
            //   0d80000000           | adc                 eax, 0x8df2e
            //   8905????????         |                     

    condition:
        7 of them and filesize < 2957312
}