rule win_regin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.regin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.regin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48 8bd3 e8???????? 40 32ff 48 8b5c2450 }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   8bd3                 | mov                 edx, ebx
            //   e8????????           |                     
            //   40                   | inc                 eax
            //   32ff                 | xor                 bh, bh
            //   48                   | dec                 eax
            //   8b5c2450             | mov                 ebx, dword ptr [esp + 0x50]

        $sequence_1 = { 41 ffc0 48 8d4c2470 41 b904000000 }
            // n = 6, score = 100
            //   41                   | inc                 ecx
            //   ffc0                 | inc                 eax
            //   48                   | dec                 eax
            //   8d4c2470             | lea                 ecx, [esp + 0x70]
            //   41                   | inc                 ecx
            //   b904000000           | mov                 ecx, 4

        $sequence_2 = { 85c0 740d 48 8d3551070000 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   48                   | dec                 eax
            //   8d3551070000         | lea                 esi, [0x751]

        $sequence_3 = { 48 0f45c7 4c 3be1 }
            // n = 4, score = 100
            //   48                   | dec                 eax
            //   0f45c7               | cmovne              eax, edi
            //   4c                   | dec                 esp
            //   3be1                 | cmp                 esp, ecx

        $sequence_4 = { 7408 33db 895c2460 eb7c 48 }
            // n = 5, score = 100
            //   7408                 | je                  0xa
            //   33db                 | xor                 ebx, ebx
            //   895c2460             | mov                 dword ptr [esp + 0x60], ebx
            //   eb7c                 | jmp                 0x7e
            //   48                   | dec                 eax

        $sequence_5 = { 7505 e8???????? e8???????? 85c0 7518 e8???????? }
            // n = 6, score = 100
            //   7505                 | jne                 7
            //   e8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7518                 | jne                 0x1a
            //   e8????????           |                     

        $sequence_6 = { 3beb 7406 ff15???????? 8ac3 48 8b9c2490000000 }
            // n = 6, score = 100
            //   3beb                 | cmp                 ebp, ebx
            //   7406                 | je                  8
            //   ff15????????         |                     
            //   8ac3                 | mov                 al, bl
            //   48                   | dec                 eax
            //   8b9c2490000000       | mov                 ebx, dword ptr [esp + 0x90]

        $sequence_7 = { 83ec28 83c8ff 48 85c9 }
            // n = 4, score = 100
            //   83ec28               | sub                 esp, 0x28
            //   83c8ff               | or                  eax, 0xffffffff
            //   48                   | dec                 eax
            //   85c9                 | test                ecx, ecx

        $sequence_8 = { 89442478 48 85c0 0f84e8000000 }
            // n = 4, score = 100
            //   89442478             | mov                 dword ptr [esp + 0x78], eax
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   0f84e8000000         | je                  0xee

        $sequence_9 = { 4c 8d4008 48 8d5010 e8???????? 3ac3 }
            // n = 6, score = 100
            //   4c                   | dec                 esp
            //   8d4008               | lea                 eax, [eax + 8]
            //   48                   | dec                 eax
            //   8d5010               | lea                 edx, [eax + 0x10]
            //   e8????????           |                     
            //   3ac3                 | cmp                 al, bl

    condition:
        7 of them and filesize < 49152
}