rule win_rektloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rektloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rektloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d5508 52 e8???????? 83c404 668945f8 8b45f4 8b484c }
            // n = 7, score = 100
            //   8d5508               | lea                 edx, [ebp + 8]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b484c               | mov                 ecx, dword ptr [eax + 0x4c]

        $sequence_1 = { 85c0 7454 8d8d30feffff 51 8b4d18 e8???????? 89855cfeffff }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7454                 | je                  0x56
            //   8d8d30feffff         | lea                 ecx, [ebp - 0x1d0]
            //   51                   | push                ecx
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   e8????????           |                     
            //   89855cfeffff         | mov                 dword ptr [ebp - 0x1a4], eax

        $sequence_2 = { 740a eb10 8b4d24 c60100 eb17 8b5524 c60201 }
            // n = 7, score = 100
            //   740a                 | je                  0xc
            //   eb10                 | jmp                 0x12
            //   8b4d24               | mov                 ecx, dword ptr [ebp + 0x24]
            //   c60100               | mov                 byte ptr [ecx], 0
            //   eb17                 | jmp                 0x19
            //   8b5524               | mov                 edx, dword ptr [ebp + 0x24]
            //   c60201               | mov                 byte ptr [edx], 1

        $sequence_3 = { 4a 00ca 48 4a 003f 49 4a }
            // n = 7, score = 100
            //   4a                   | dec                 edx
            //   00ca                 | add                 dl, cl
            //   48                   | dec                 eax
            //   4a                   | dec                 edx
            //   003f                 | add                 byte ptr [edi], bh
            //   49                   | dec                 ecx
            //   4a                   | dec                 edx

        $sequence_4 = { e8???????? 8bf4 50 8b4508 50 8b4df4 8b11 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf4                 | mov                 esi, esp
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b11                 | mov                 edx, dword ptr [ecx]

        $sequence_5 = { ff15???????? 3305???????? b904000000 6bd11c 898278995600 68???????? 8b45fc }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   3305????????         |                     
            //   b904000000           | mov                 ecx, 4
            //   6bd11c               | imul                edx, ecx, 0x1c
            //   898278995600         | mov                 dword ptr [edx + 0x569978], eax
            //   68????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { 55 8bec 83ec08 b804000000 6bc80a 8b9178995600 3315???????? }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   b804000000           | mov                 eax, 4
            //   6bc80a               | imul                ecx, eax, 0xa
            //   8b9178995600         | mov                 edx, dword ptr [ecx + 0x569978]
            //   3315????????         |                     

        $sequence_7 = { 51 c745fccccccccc 894dfc 8d450c 50 8d4d08 51 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   c745fccccccccc       | mov                 dword ptr [ebp - 4], 0xcccccccc
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   51                   | push                ecx

        $sequence_8 = { e9???????? 8d4dd4 e9???????? 8d8d50ffffff e9???????? 8d4db8 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e9????????           |                     
            //   8d8d50ffffff         | lea                 ecx, [ebp - 0xb0]
            //   e9????????           |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e9????????           |                     

        $sequence_9 = { 6bc807 8b9178995600 3315???????? 8955f4 7424 8b4514 50 }
            // n = 7, score = 100
            //   6bc807               | imul                ecx, eax, 7
            //   8b9178995600         | mov                 edx, dword ptr [ecx + 0x569978]
            //   3315????????         |                     
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   7424                 | je                  0x26
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 3080192
}