rule win_remexi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.remexi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remexi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 c706ffffffff e8???????? 83c404 }
            // n = 4, score = 300
            //   56                   | push                esi
            //   c706ffffffff         | mov                 dword ptr [esi], 0xffffffff
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { 890d???????? 68???????? 41 50 a3???????? c705????????02000000 890d???????? }
            // n = 7, score = 200
            //   890d????????         |                     
            //   68????????           |                     
            //   41                   | inc                 ecx
            //   50                   | push                eax
            //   a3????????           |                     
            //   c705????????02000000     |     
            //   890d????????         |                     

        $sequence_2 = { 68???????? 50 ff15???????? 8b0d???????? 8b35???????? 890d???????? 68???????? }
            // n = 7, score = 200
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   8b35????????         |                     
            //   890d????????         |                     
            //   68????????           |                     

        $sequence_3 = { 6a10 8d4ddc 8bf0 51 }
            // n = 4, score = 200
            //   6a10                 | mov                 edx, dword ptr [ecx + 4]
            //   8d4ddc               | jne                 0x15
            //   8bf0                 | mov                 eax, dword ptr [ebp - 0x28]
            //   51                   | mov                 ecx, dword ptr [eax + 0x18]

        $sequence_4 = { 6a00 6a02 c785ccfeffff28010000 ff15???????? }
            // n = 4, score = 200
            //   6a00                 | push                0x10
            //   6a02                 | push                0
            //   c785ccfeffff28010000     | push    eax
            //   ff15????????         |                     

        $sequence_5 = { 5f c3 56 ff15???????? 57 8b3d???????? }
            // n = 6, score = 200
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8b3d????????         |                     

        $sequence_6 = { 8945e4 8945e8 b802000000 51 }
            // n = 4, score = 200
            //   8945e4               | lea                 ecx, [ebp - 0x24]
            //   8945e8               | mov                 esi, eax
            //   b802000000           | push                ecx
            //   51                   | push                edx

        $sequence_7 = { 56 6824000100 50 57 ff15???????? }
            // n = 5, score = 200
            //   56                   | push                esi
            //   6824000100           | push                0x10024
            //   50                   | push                eax
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_8 = { a3???????? c705????????02000000 890d???????? ffd6 6a00 6a00 6a00 }
            // n = 7, score = 200
            //   a3????????           |                     
            //   c705????????02000000     |     
            //   890d????????         |                     
            //   ffd6                 | call                esi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_9 = { 6828010000 8d8dccfeffff 6a00 51 }
            // n = 4, score = 200
            //   6828010000           | push                esi
            //   8d8dccfeffff         | push                edi
            //   6a00                 | push                esi
            //   51                   | push                0x10024

        $sequence_10 = { 50 6a02 ff15???????? 6a10 8d4ddc }
            // n = 5, score = 200
            //   50                   | push                eax
            //   6a02                 | xor                 eax, eax
            //   ff15????????         |                     
            //   6a10                 | pop                 edi
            //   8d4ddc               | ret                 

        $sequence_11 = { 7513 8b45d8 8b4818 8b5104 }
            // n = 4, score = 200
            //   7513                 | push                eax
            //   8b45d8               | push                edi
            //   8b4818               | mov                 esi, eax
            //   8b5104               | test                esi, esi

        $sequence_12 = { 89470c 57 894710 ff15???????? 6a00 6a00 6a01 }
            // n = 7, score = 200
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   57                   | push                edi
            //   894710               | mov                 dword ptr [edi + 0x10], eax
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_13 = { c705????????ffffffff c705????????01000000 c705????????00000000 ffd6 83ffff }
            // n = 5, score = 200
            //   c705????????ffffffff     |     
            //   c705????????01000000     |     
            //   c705????????00000000     |     
            //   ffd6                 | call                esi
            //   83ffff               | cmp                 edi, -1

        $sequence_14 = { 52 6a00 68ffff1f00 ffd7 8bf0 }
            // n = 5, score = 200
            //   52                   | push                ecx
            //   6a00                 | push                0x10
            //   68ffff1f00           | lea                 ecx, [ebp - 0x24]
            //   ffd7                 | mov                 esi, eax
            //   8bf0                 | push                ecx

        $sequence_15 = { 015518 8b5d14 85db 0f8565fbffff }
            // n = 4, score = 100
            //   015518               | add                 dword ptr [ebp + 0x18], edx
            //   8b5d14               | mov                 ebx, dword ptr [ebp + 0x14]
            //   85db                 | test                ebx, ebx
            //   0f8565fbffff         | jne                 0xfffffb6b

        $sequence_16 = { 488d542450 488d4c2420 e8???????? 488d442420 4889442440 488d542420 }
            // n = 6, score = 100
            //   488d542450           | ret                 
            //   488d4c2420           | inc                 eax
            //   e8????????           |                     
            //   488d442420           | push                ebx
            //   4889442440           | dec                 eax
            //   488d542420           | sub                 esp, 0x20

        $sequence_17 = { 015330 41 894b0c e9???????? }
            // n = 4, score = 100
            //   015330               | add                 dword ptr [ebx + 0x30], edx
            //   41                   | inc                 ecx
            //   894b0c               | mov                 dword ptr [ebx + 0xc], ecx
            //   e9????????           |                     

        $sequence_18 = { 488bc3 c60000 44897320 41b901000000 488d1529f30100 488bcf }
            // n = 6, score = 100
            //   488bc3               | dec                 eax
            //   c60000               | mov                 eax, ebx
            //   44897320             | mov                 byte ptr [eax], 0
            //   41b901000000         | inc                 esp
            //   488d1529f30100       | mov                 dword ptr [ebx + 0x20], esi
            //   488bcf               | inc                 ecx

        $sequence_19 = { 016b24 89e8 83c44c 5b }
            // n = 4, score = 100
            //   016b24               | add                 dword ptr [ebx + 0x24], ebp
            //   89e8                 | mov                 eax, ebp
            //   83c44c               | add                 esp, 0x4c
            //   5b                   | pop                 ebx

        $sequence_20 = { 4898 4885c0 7515 4883fb06 7305 }
            // n = 5, score = 100
            //   4898                 | dec                 eax
            //   4885c0               | lea                 ecx, [0x13473]
            //   7515                 | dec                 eax
            //   4883fb06             | lea                 edx, [0x13486]
            //   7305                 | dec                 eax

        $sequence_21 = { 015930 3b542408 0f8d10ffffff 8d3c52 }
            // n = 4, score = 100
            //   015930               | add                 dword ptr [ecx + 0x30], ebx
            //   3b542408             | cmp                 edx, dword ptr [esp + 8]
            //   0f8d10ffffff         | jge                 0xffffff16
            //   8d3c52               | lea                 edi, [edx + edx*2]

        $sequence_22 = { 488bcf e8???????? 4885db 0f8428010000 48837f1810 7227 }
            // n = 6, score = 100
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   4885db               | mov                 dword ptr [esp + 0x40], eax
            //   0f8428010000         | dec                 eax
            //   48837f1810           | lea                 edx, [esp + 0x20]
            //   7227                 | dec                 eax

        $sequence_23 = { 7468 48c74424380f000000 48897c2430 c644242000 4983c9ff }
            // n = 5, score = 100
            //   7468                 | lea                 edx, [esp + 0x50]
            //   48c74424380f000000     | dec    eax
            //   48897c2430           | lea                 ecx, [esp + 0x20]
            //   c644242000           | dec                 eax
            //   4983c9ff             | lea                 eax, [esp + 0x20]

        $sequence_24 = { 015330 e9???????? 8b5314 3b5318 0f8d23020000 }
            // n = 5, score = 100
            //   015330               | add                 dword ptr [ebx + 0x30], edx
            //   e9????????           |                     
            //   8b5314               | mov                 edx, dword ptr [ebx + 0x14]
            //   3b5318               | cmp                 edx, dword ptr [ebx + 0x18]
            //   0f8d23020000         | jge                 0x229

        $sequence_25 = { 014b30 bf???????? b903000000 8b742418 }
            // n = 4, score = 100
            //   014b30               | add                 dword ptr [ebx + 0x30], ecx
            //   bf????????           |                     
            //   b903000000           | mov                 ecx, 3
            //   8b742418             | mov                 esi, dword ptr [esp + 0x18]

        $sequence_26 = { e8???????? 48837f1810 48895f10 7205 488b07 eb03 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   48837f1810           | cwde                
            //   48895f10             | dec                 eax
            //   7205                 | test                eax, eax
            //   488b07               | jne                 0x17
            //   eb03                 | dec                 eax

        $sequence_27 = { c3 4053 4883ec20 488d0d73340100 ff15???????? 488d1586340100 }
            // n = 6, score = 100
            //   c3                   | mov                 ecx, 1
            //   4053                 | dec                 eax
            //   4883ec20             | lea                 edx, [0x1f329]
            //   488d0d73340100       | dec                 eax
            //   ff15????????         |                     
            //   488d1586340100       | mov                 ecx, edi

        $sequence_28 = { 015330 8a10 eb84 8a5001 }
            // n = 4, score = 100
            //   015330               | add                 dword ptr [ebx + 0x30], edx
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   eb84                 | jmp                 0xffffff86
            //   8a5001               | mov                 dl, byte ptr [eax + 1]

        $sequence_29 = { 016b04 83c41c 5b 5e }
            // n = 4, score = 100
            //   016b04               | add                 dword ptr [ebx + 4], ebp
            //   83c41c               | add                 esp, 0x1c
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_30 = { 0f8540010000 488d1583310100 488bcb e8???????? 4c8bf0 4885c0 0f8421010000 }
            // n = 7, score = 100
            //   0f8540010000         | cmp                 ebx, 6
            //   488d1583310100       | jae                 0xd
            //   488bcb               | je                  0x6a
            //   e8????????           |                     
            //   4c8bf0               | dec                 eax
            //   4885c0               | mov                 dword ptr [esp + 0x38], 0xf
            //   0f8421010000         | dec                 eax

    condition:
        7 of them and filesize < 614400
}