rule win_remsec_strider_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.remsec_strider."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remsec_strider"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? c700???????? c74024282d8000 897828 8b481c c7412003000000 89782c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c700????????         |                     
            //   c74024282d8000       | mov                 dword ptr [eax + 0x24], 0x802d28
            //   897828               | mov                 dword ptr [eax + 0x28], edi
            //   8b481c               | mov                 ecx, dword ptr [eax + 0x1c]
            //   c7412003000000       | mov                 dword ptr [ecx + 0x20], 3
            //   89782c               | mov                 dword ptr [eax + 0x2c], edi

        $sequence_1 = { e8???????? 8bc8 6a01 8bc3 e8???????? 83c40c 83c8ff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   6a01                 | push                1
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_2 = { 2345fc d3e8 0fb74de2 03c1 8b4e4c 8b0481 8bc8 }
            // n = 7, score = 100
            //   2345fc               | and                 eax, dword ptr [ebp - 4]
            //   d3e8                 | shr                 eax, cl
            //   0fb74de2             | movzx               ecx, word ptr [ebp - 0x1e]
            //   03c1                 | add                 eax, ecx
            //   8b4e4c               | mov                 ecx, dword ptr [esi + 0x4c]
            //   8b0481               | mov                 eax, dword ptr [ecx + eax*4]
            //   8bc8                 | mov                 ecx, eax

        $sequence_3 = { 6a04 59 83460810 8b55f4 0fb75a02 8b4608 0fb7d3 }
            // n = 7, score = 100
            //   6a04                 | push                4
            //   59                   | pop                 ecx
            //   83460810             | add                 dword ptr [esi + 8], 0x10
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   0fb75a02             | movzx               ebx, word ptr [edx + 2]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   0fb7d3               | movzx               edx, bx

        $sequence_4 = { ff4dfc 75d1 8bc6 e8???????? 8bf8 8d4701 3dffffff3f }
            // n = 7, score = 100
            //   ff4dfc               | dec                 dword ptr [ebp - 4]
            //   75d1                 | jne                 0xffffffd3
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8d4701               | lea                 eax, [edi + 1]
            //   3dffffff3f           | cmp                 eax, 0x3fffffff

        $sequence_5 = { 5e 5b c3 8b4010 80781501 750d }
            // n = 6, score = 100
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   80781501             | cmp                 byte ptr [eax + 0x15], 1
            //   750d                 | jne                 0xf

        $sequence_6 = { 8b4628 8b4e14 8bfb eb0c 8b5008 3bfa 7302 }
            // n = 7, score = 100
            //   8b4628               | mov                 eax, dword ptr [esi + 0x28]
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   8bfb                 | mov                 edi, ebx
            //   eb0c                 | jmp                 0xe
            //   8b5008               | mov                 edx, dword ptr [eax + 8]
            //   3bfa                 | cmp                 edi, edx
            //   7302                 | jae                 4

        $sequence_7 = { 8bd8 8b4310 8b4844 56 3b4840 7205 e8???????? }
            // n = 7, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   8b4844               | mov                 ecx, dword ptr [eax + 0x44]
            //   56                   | push                esi
            //   3b4840               | cmp                 ecx, dword ptr [eax + 0x40]
            //   7205                 | jb                  7
            //   e8????????           |                     

        $sequence_8 = { 0f859af6ffff 8b44240c dd16 c1ef0e 8d84b80400f8ff 6a03 }
            // n = 6, score = 100
            //   0f859af6ffff         | jne                 0xfffff6a0
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   dd16                 | fst                 qword ptr [esi]
            //   c1ef0e               | shr                 edi, 0xe
            //   8d84b80400f8ff       | lea                 eax, [eax + edi*4 - 0x7fffc]
            //   6a03                 | push                3

        $sequence_9 = { e9???????? 8b06 834008f0 8b36 b8ffff0000 66014634 8bc7 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   834008f0             | add                 dword ptr [eax + 8], -0x10
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   b8ffff0000           | mov                 eax, 0xffff
            //   66014634             | add                 word ptr [esi + 0x34], ax
            //   8bc7                 | mov                 eax, edi

    condition:
        7 of them and filesize < 327680
}