rule win_resident_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.resident."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.resident"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 8d95dcf9ffff 52 6a00 ff15???????? 85c0 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   8d95dcf9ffff         | lea                 edx, [ebp - 0x624]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_1 = { c1e606 03348500b94000 8b45f8 8b00 8906 8b45fc 8a00 }
            // n = 7, score = 100
            //   c1e606               | shl                 esi, 6
            //   03348500b94000       | add                 esi, dword ptr [eax*4 + 0x40b900]
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8a00                 | mov                 al, byte ptr [eax]

        $sequence_2 = { 894c243c 8b4c2460 89442404 89542440 8b54245c }
            // n = 5, score = 100
            //   894c243c             | mov                 dword ptr [esp + 0x3c], ecx
            //   8b4c2460             | mov                 ecx, dword ptr [esp + 0x60]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   89542440             | mov                 dword ptr [esp + 0x40], edx
            //   8b54245c             | mov                 edx, dword ptr [esp + 0x5c]

        $sequence_3 = { 895c2410 c744240cffffffff 89742408 c744240400000000 }
            // n = 4, score = 100
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   c744240cffffffff     | mov                 dword ptr [esp + 0xc], 0xffffffff
            //   89742408             | mov                 dword ptr [esp + 8], esi
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0

        $sequence_4 = { e8???????? 89c6 85c0 0f8427010000 c70424???????? 8d6c243e e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   89c6                 | mov                 esi, eax
            //   85c0                 | test                eax, eax
            //   0f8427010000         | je                  0x12d
            //   c70424????????       |                     
            //   8d6c243e             | lea                 ebp, [esp + 0x3e]
            //   e8????????           |                     

        $sequence_5 = { 8d85d8f9ffff e8???????? 8b95d4f9ffff 8bf0 03d2 8d45dc e8???????? }
            // n = 7, score = 100
            //   8d85d8f9ffff         | lea                 eax, [ebp - 0x628]
            //   e8????????           |                     
            //   8b95d4f9ffff         | mov                 edx, dword ptr [ebp - 0x62c]
            //   8bf0                 | mov                 esi, eax
            //   03d2                 | add                 edx, edx
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   e8????????           |                     

        $sequence_6 = { 750f 33c0 807dfa01 0f94c0 8d740010 eb41 83f803 }
            // n = 7, score = 100
            //   750f                 | jne                 0x11
            //   33c0                 | xor                 eax, eax
            //   807dfa01             | cmp                 byte ptr [ebp - 6], 1
            //   0f94c0               | sete                al
            //   8d740010             | lea                 esi, [eax + eax + 0x10]
            //   eb41                 | jmp                 0x43
            //   83f803               | cmp                 eax, 3

        $sequence_7 = { 8d55e4 52 ffd6 85c0 75e3 5b }
            // n = 6, score = 100
            //   8d55e4               | lea                 edx, [ebp - 0x1c]
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   75e3                 | jne                 0xffffffe5
            //   5b                   | pop                 ebx

        $sequence_8 = { 6689442430 668954242c 8b542422 b830000000 6689442428 66894c242e 0fb74c2420 }
            // n = 7, score = 100
            //   6689442430           | mov                 word ptr [esp + 0x30], ax
            //   668954242c           | mov                 word ptr [esp + 0x2c], dx
            //   8b542422             | mov                 edx, dword ptr [esp + 0x22]
            //   b830000000           | mov                 eax, 0x30
            //   6689442428           | mov                 word ptr [esp + 0x28], ax
            //   66894c242e           | mov                 word ptr [esp + 0x2e], cx
            //   0fb74c2420           | movzx               ecx, word ptr [esp + 0x20]

        $sequence_9 = { c744240800000000 c744240400000000 ff15???????? 83ec20 891c24 e8???????? }
            // n = 6, score = 100
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   ff15????????         |                     
            //   83ec20               | sub                 esp, 0x20
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     

        $sequence_10 = { 8d34ad00000000 8b04a8 890424 e8???????? 83f825 76da }
            // n = 6, score = 100
            //   8d34ad00000000       | lea                 esi, [ebp*4]
            //   8b04a8               | mov                 eax, dword ptr [eax + ebp*4]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   83f825               | cmp                 eax, 0x25
            //   76da                 | jbe                 0xffffffdc

        $sequence_11 = { 8b37 89442418 8d460a 890424 e8???????? 89c3 85c0 }
            // n = 7, score = 100
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   8d460a               | lea                 eax, [esi + 0xa]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   89c3                 | mov                 ebx, eax
            //   85c0                 | test                eax, eax

        $sequence_12 = { 75e4 b801000000 893c24 8944241c e8???????? }
            // n = 5, score = 100
            //   75e4                 | jne                 0xffffffe6
            //   b801000000           | mov                 eax, 1
            //   893c24               | mov                 dword ptr [esp], edi
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   e8????????           |                     

        $sequence_13 = { ff15???????? 6a04 8d55fc 52 6a06 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   6a04                 | push                4
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   52                   | push                edx
            //   6a06                 | push                6

        $sequence_14 = { ff15???????? 83ec04 0fb7442446 66895c2450 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   83ec04               | sub                 esp, 4
            //   0fb7442446           | movzx               eax, word ptr [esp + 0x46]
            //   66895c2450           | mov                 word ptr [esp + 0x50], bx

        $sequence_15 = { eb05 e8???????? 83c404 84c0 0f848e000000 }
            // n = 5, score = 100
            //   eb05                 | jmp                 7
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   84c0                 | test                al, al
            //   0f848e000000         | je                  0x94

    condition:
        7 of them and filesize < 125952
}