rule win_retefe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.retefe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.retefe"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 8bf8 ffd6 85c0 }
            // n = 4, score = 1200
            //   51                   | push                ecx
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax

        $sequence_1 = { 68f5000000 50 ff15???????? b801000000 }
            // n = 4, score = 1200
            //   68f5000000           | push                0xf5
            //   50                   | push                eax
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1

        $sequence_2 = { e8???????? 6a08 e8???????? 894604 83c404 }
            // n = 5, score = 800
            //   e8????????           |                     
            //   6a08                 | push                8
            //   e8????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   83c404               | add                 esp, 4

        $sequence_3 = { 6a1c 6ae1 6aa5 6a00 6a14 6aea 6abe }
            // n = 7, score = 800
            //   6a1c                 | push                0x1c
            //   6ae1                 | push                -0x1f
            //   6aa5                 | push                -0x5b
            //   6a00                 | push                0
            //   6a14                 | push                0x14
            //   6aea                 | push                -0x16
            //   6abe                 | push                -0x42

        $sequence_4 = { 894604 83c404 8bc6 e8???????? }
            // n = 4, score = 800
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   83c404               | add                 esp, 4
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     

        $sequence_5 = { 6adb 6a1c 6ad8 6a2f 6ad1 6a0a }
            // n = 6, score = 800
            //   6adb                 | push                -0x25
            //   6a1c                 | push                0x1c
            //   6ad8                 | push                -0x28
            //   6a2f                 | push                0x2f
            //   6ad1                 | push                -0x2f
            //   6a0a                 | push                0xa

        $sequence_6 = { 6ada 6a53 6ac7 6a36 6acb 6a18 6ac4 }
            // n = 7, score = 800
            //   6ada                 | push                -0x26
            //   6a53                 | push                0x53
            //   6ac7                 | push                -0x39
            //   6a36                 | push                0x36
            //   6acb                 | push                -0x35
            //   6a18                 | push                0x18
            //   6ac4                 | push                -0x3c

        $sequence_7 = { 8901 8b4e04 33c0 83c404 394104 }
            // n = 5, score = 800
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   33c0                 | xor                 eax, eax
            //   83c404               | add                 esp, 4
            //   394104               | cmp                 dword ptr [ecx + 4], eax

        $sequence_8 = { 8b4e04 40 3b4104 72ec }
            // n = 4, score = 800
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   40                   | inc                 eax
            //   3b4104               | cmp                 eax, dword ptr [ecx + 4]
            //   72ec                 | jb                  0xffffffee

        $sequence_9 = { e8???????? 8b4e04 8901 8b4e04 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]

        $sequence_10 = { 51 8d9570efffff 52 50 50 50 6a01 }
            // n = 7, score = 800
            //   51                   | push                ecx
            //   8d9570efffff         | lea                 edx, [ebp - 0x1090]
            //   52                   | push                edx
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax
            //   6a01                 | push                1

        $sequence_11 = { 6afa 6acb 6a12 6a79 }
            // n = 4, score = 800
            //   6afa                 | push                -6
            //   6acb                 | push                -0x35
            //   6a12                 | push                0x12
            //   6a79                 | push                0x79

        $sequence_12 = { c1eb18 884101 c1ea10 33c0 }
            // n = 4, score = 800
            //   c1eb18               | shr                 ebx, 0x18
            //   884101               | mov                 byte ptr [ecx + 1], al
            //   c1ea10               | shr                 edx, 0x10
            //   33c0                 | xor                 eax, eax

        $sequence_13 = { 50 e8???????? 88043e 46 83c404 3bf3 75ec }
            // n = 7, score = 600
            //   50                   | push                eax
            //   e8????????           |                     
            //   88043e               | mov                 byte ptr [esi + edi], al
            //   46                   | inc                 esi
            //   83c404               | add                 esp, 4
            //   3bf3                 | cmp                 esi, ebx
            //   75ec                 | jne                 0xffffffee

        $sequence_14 = { 0f8520010000 33c0 8ad8 8d8d04dcffff }
            // n = 4, score = 100
            //   0f8520010000         | jne                 0x126
            //   33c0                 | xor                 eax, eax
            //   8ad8                 | mov                 bl, al
            //   8d8d04dcffff         | lea                 ecx, [ebp - 0x23fc]

        $sequence_15 = { 803800 740b 6a18 59 }
            // n = 4, score = 100
            //   803800               | cmp                 byte ptr [eax], 0
            //   740b                 | je                  0xd
            //   6a18                 | push                0x18
            //   59                   | pop                 ecx

        $sequence_16 = { 83e809 7443 83e801 0f8501010000 c745e014344100 8b4508 8bcf }
            // n = 7, score = 100
            //   83e809               | sub                 eax, 9
            //   7443                 | je                  0x45
            //   83e801               | sub                 eax, 1
            //   0f8501010000         | jne                 0x107
            //   c745e014344100       | mov                 dword ptr [ebp - 0x20], 0x413414
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bcf                 | mov                 ecx, edi

        $sequence_17 = { 5d 5b c20800 833d????????00 }
            // n = 4, score = 100
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   c20800               | ret                 8
            //   833d????????00       |                     

        $sequence_18 = { 8b7c2410 85f6 0f840b010000 53 e8???????? }
            // n = 5, score = 100
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   85f6                 | test                esi, esi
            //   0f840b010000         | je                  0x111
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_19 = { 6a00 e8???????? 803d????????00 750c 8d859cdeffff }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   e8????????           |                     
            //   803d????????00       |                     
            //   750c                 | jne                 0xe
            //   8d859cdeffff         | lea                 eax, [ebp - 0x2164]

        $sequence_20 = { 8b0e 394104 761c 660f1f840000000000 8b11 8a88503e4100 }
            // n = 6, score = 100
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   394104               | cmp                 dword ptr [ecx + 4], eax
            //   761c                 | jbe                 0x1e
            //   660f1f840000000000     | nop    word ptr [eax + eax]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8a88503e4100         | mov                 cl, byte ptr [eax + 0x413e50]

        $sequence_21 = { ff5004 8b4ddc 8b4104 895904 85c0 7406 8b08 }
            // n = 7, score = 100
            //   ff5004               | call                dword ptr [eax + 4]
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   895904               | mov                 dword ptr [ecx + 4], ebx
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_22 = { 8bf0 8b5508 83c9ff 83c2f0 f00fc14a0c }
            // n = 5, score = 100
            //   8bf0                 | mov                 esi, eax
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   83c2f0               | add                 edx, -0x10
            //   f00fc14a0c           | lock xadd           dword ptr [edx + 0xc], ecx

        $sequence_23 = { 8b5c2418 89442434 8b44241c 8d48f8 }
            // n = 4, score = 100
            //   8b5c2418             | mov                 ebx, dword ptr [esp + 0x18]
            //   89442434             | mov                 dword ptr [esp + 0x34], eax
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8d48f8               | lea                 ecx, [eax - 8]

        $sequence_24 = { 33c0 668945e8 8b45d4 886de5 8b1485a0bf4200 }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   668945e8             | mov                 word ptr [ebp - 0x18], ax
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   886de5               | mov                 byte ptr [ebp - 0x1b], ch
            //   8b1485a0bf4200       | mov                 edx, dword ptr [eax*4 + 0x42bfa0]

        $sequence_25 = { 897de0 394508 7c1f 3934bd08d44500 }
            // n = 4, score = 100
            //   897de0               | mov                 dword ptr [ebp - 0x20], edi
            //   394508               | cmp                 dword ptr [ebp + 8], eax
            //   7c1f                 | jl                  0x21
            //   3934bd08d44500       | cmp                 dword ptr [edi*4 + 0x45d408], esi

        $sequence_26 = { 57 8d3c85a8c14200 8b0f 85c9 740b 8d4101 f7d8 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d3c85a8c14200       | lea                 edi, [eax*4 + 0x42c1a8]
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   85c9                 | test                ecx, ecx
            //   740b                 | je                  0xd
            //   8d4101               | lea                 eax, [ecx + 1]
            //   f7d8                 | neg                 eax

        $sequence_27 = { 8b01 51 ff5008 8b4e0c 85c9 7406 }
            // n = 6, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   51                   | push                ecx
            //   ff5008               | call                dword ptr [eax + 8]
            //   8b4e0c               | mov                 ecx, dword ptr [esi + 0xc]
            //   85c9                 | test                ecx, ecx
            //   7406                 | je                  8

        $sequence_28 = { 7ead 8b0d???????? 8d857869ffff 6a00 }
            // n = 4, score = 100
            //   7ead                 | jle                 0xffffffaf
            //   8b0d????????         |                     
            //   8d857869ffff         | lea                 eax, [ebp - 0x9688]
            //   6a00                 | push                0

        $sequence_29 = { 0fb6c0 eb17 81fa00010000 7313 8a87ccb14200 08441619 }
            // n = 6, score = 100
            //   0fb6c0               | movzx               eax, al
            //   eb17                 | jmp                 0x19
            //   81fa00010000         | cmp                 edx, 0x100
            //   7313                 | jae                 0x15
            //   8a87ccb14200         | mov                 al, byte ptr [edi + 0x42b1cc]
            //   08441619             | or                  byte ptr [esi + edx + 0x19], al

    condition:
        7 of them and filesize < 843776
}