rule win_revenant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.revenant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.revenant"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41803c1c20 488d4301 7405 4889c3 ebeb 8d4b01 }
            // n = 6, score = 100
            //   41803c1c20           | mov                 eax, dword ptr [ebx + 0x10]
            //   488d4301             | dec                 eax
            //   7405                 | mov                 dword ptr [ebx + 0x18], eax
            //   4889c3               | dec                 eax
            //   ebeb                 | add                 eax, 4
            //   8d4b01               | dec                 eax

        $sequence_1 = { 7592 41c744240801000000 b801000000 4881c458010000 }
            // n = 4, score = 100
            //   7592                 | dec                 eax
            //   41c744240801000000     | mov    edx, esi
            //   b801000000           | dec                 eax
            //   4881c458010000       | mov                 ecx, dword ptr [ecx + 8]

        $sequence_2 = { 31c9 488b2d???????? 4989f0 ffd5 4c8b35???????? 85c0 7521 }
            // n = 7, score = 100
            //   31c9                 | inc                 ebp
            //   488b2d????????       |                     
            //   4989f0               | xor                 ecx, ecx
            //   ffd5                 | dec                 eax
            //   4c8b35????????       |                     
            //   85c0                 | mov                 ecx, dword ptr [edi + 0x28]
            //   7521                 | inc                 esp

        $sequence_3 = { 488b542420 e8???????? 4c8b442428 31d2 488b4c2420 e8???????? }
            // n = 6, score = 100
            //   488b542420           | je                  0x1e21
            //   e8????????           |                     
            //   4c8b442428           | mov                 ecx, dword ptr [ecx + 0x10]
            //   31d2                 | xor                 eax, eax
            //   488b4c2420           | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { e8???????? 4885c0 4889c6 7465 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   4885c0               | dec                 ecx
            //   4889c6               | cmp                 eax, ecx
            //   7465                 | je                  0x49c

        $sequence_5 = { 4531c9 440fb74738 488b4c2448 e8???????? 4885c0 }
            // n = 5, score = 100
            //   4531c9               | test                ebp, ebp
            //   440fb74738           | test                ecx, ecx
            //   488b4c2448           | je                  0x56d
            //   e8????????           |                     
            //   4885c0               | test                edx, edx

        $sequence_6 = { f3a4 488b7c2438 8b4c2448 f3aa }
            // n = 4, score = 100
            //   f3a4                 | mov                 byte ptr [eax + ecx], cl
            //   488b7c2438           | dec                 esp
            //   8b4c2448             | mov                 dword ptr [esp + 0x20], eax
            //   f3aa                 | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { 4889f1 ff15???????? b940000000 89c5 4889ea }
            // n = 5, score = 100
            //   4889f1               | mov                 ecx, dword ptr [esp + 0x48]
            //   ff15????????         |                     
            //   b940000000           | rep stosb           byte ptr es:[edi], al
            //   89c5                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   4889ea               | dec                 eax

        $sequence_8 = { ff15???????? 488d0dc82d0000 31f6 89c2 e8???????? e9???????? 837f3c00 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488d0dc82d0000       | xor                 eax, eax
            //   31f6                 | xor                 edx, edx
            //   89c2                 | dec                 esp
            //   e8????????           |                     
            //   e9????????           |                     
            //   837f3c00             | mov                 ecx, esp

        $sequence_9 = { 89c5 4889ea 896c244c ff15???????? 448b44244c }
            // n = 5, score = 100
            //   89c5                 | sub                 esp, 0x38
            //   4889ea               | xor                 eax, eax
            //   896c244c             | mov                 dword ptr [esp + 0x2c], eax
            //   ff15????????         |                     
            //   448b44244c           | dec                 eax

    condition:
        7 of them and filesize < 99328
}