rule win_rgdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rgdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rgdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d0dbe380200 4c8b442448 488b542438 488b4c2440 83bc24c800000000 7413 }
            // n = 6, score = 100
            //   4c8d0dbe380200       | inc                 ecx
            //   4c8b442448           | mov                 eax, 1
            //   488b542438           | dec                 eax
            //   488b4c2440           | mov                 dword ptr [esp + 0x58], eax
            //   83bc24c800000000     | dec                 eax
            //   7413                 | lea                 eax, [0x1b818]

        $sequence_1 = { 488d0d53170100 e8???????? 85c0 754a 488d0d774a0000 e8???????? 488d152f170100 }
            // n = 7, score = 100
            //   488d0d53170100       | test                eax, eax
            //   e8????????           |                     
            //   85c0                 | je                  0x1cb0
            //   754a                 | xor                 ecx, ecx
            //   488d0d774a0000       | dec                 esp
            //   e8????????           |                     
            //   488d152f170100       | mov                 ebp, eax

        $sequence_2 = { ff15???????? 488d15e3580100 483305???????? 488bcb 488905???????? ff15???????? 488d15e5580100 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488d15e3580100       | dec                 eax
            //   483305????????       |                     
            //   488bcb               | lea                 ecx, [0x4a77]
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15e5580100       | dec                 eax

        $sequence_3 = { 4c8d25d8310200 83e01f 4c6bf858 498b04fc 420fbe4c3808 83e101 7449 }
            // n = 7, score = 100
            //   4c8d25d8310200       | dec                 eax
            //   83e01f               | lea                 edx, [0x2e2be]
            //   4c6bf858             | dec                 eax
            //   498b04fc             | lea                 ecx, [esp + 0x30]
            //   420fbe4c3808         | int3                
            //   83e101               | dec                 eax
            //   7449                 | mov                 edx, edi

        $sequence_4 = { 488d4c2420 41b801000000 4889442458 e8???????? 488d05e6840100 488d154f530200 488d4c2420 }
            // n = 7, score = 100
            //   488d4c2420           | dec                 ecx
            //   41b801000000         | mov                 eax, dword ptr [eax + edx*8]
            //   4889442458           | mov                 byte ptr [eax + ecx + 8], 0x89
            //   e8????????           |                     
            //   488d05e6840100       | dec                 eax
            //   488d154f530200       | mov                 dword ptr [eax + 0x10], ebx
            //   488d4c2420           | dec                 eax

        $sequence_5 = { e8???????? 4c8bf8 4889842488000000 4885c0 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   4c8bf8               | lea                 edx, [0x28b68]
            //   4889842488000000     | dec                 eax
            //   4885c0               | lea                 ecx, [ebp - 0x68]

        $sequence_6 = { 4863ca 0fb7444b0c 6641898448c0410300 ffc2 ebe2 8bd7 }
            // n = 6, score = 100
            //   4863ca               | dec                 esp
            //   0fb7444b0c           | lea                 esi, [0x1edd6]
            //   6641898448c0410300     | inc    ecx
            //   ffc2                 | mov                 eax, 0x104
            //   ebe2                 | xor                 ecx, ecx
            //   8bd7                 | mov                 byte ptr [ebx + 0x88], 0

        $sequence_7 = { e8???????? 488bf0 488b8de0000000 48635104 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   488bf0               | lea                 esi, [0x15e36]
            //   488b8de0000000       | lea                 eax, [esi + edi]
            //   48635104             | inc                 ecx

        $sequence_8 = { e9???????? 488d8a98000000 e9???????? 488d8ae0010000 e9???????? 488d8a60000000 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d8a98000000       | mov                 eax, ecx
            //   e9????????           |                     
            //   488d8ae0010000       | dec                 eax
            //   e9????????           |                     
            //   488d8a60000000       | mov                 edx, edi
            //   e9????????           |                     

        $sequence_9 = { 4c8d3d6c3c0100 4c8d6738 4c8d05e13d0100 488bd3 498bce e8???????? }
            // n = 6, score = 100
            //   4c8d3d6c3c0100       | arpl                word ptr [eax + 4], dx
            //   4c8d6738             | inc                 esp
            //   4c8d05e13d0100       | lea                 eax, [edx - 0xa8]
            //   488bd3               | inc                 esp
            //   498bce               | mov                 dword ptr [edx + edi - 4], eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 475136
}