rule win_rhttpctrl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rhttpctrl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhttpctrl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { d1fe 6a55 ff34f5c0d54100 ff7508 e8???????? 83c40c 85c0 }
            // n = 7, score = 100
            //   d1fe                 | sar                 esi, 1
            //   6a55                 | push                0x55
            //   ff34f5c0d54100       | push                dword ptr [esi*8 + 0x41d5c0]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_1 = { ffd7 8b4c241c ff742410 8b35???????? 894114 ffd6 }
            // n = 6, score = 100
            //   ffd7                 | call                edi
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   8b35????????         |                     
            //   894114               | mov                 dword ptr [ecx + 0x14], eax
            //   ffd6                 | call                esi

        $sequence_2 = { 6a00 8d442418 50 8d4714 50 56 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   8d4714               | lea                 eax, [edi + 0x14]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_3 = { 2bc3 39460c 0f8660ffffff 50 53 6aff ff7608 }
            // n = 7, score = 100
            //   2bc3                 | sub                 eax, ebx
            //   39460c               | cmp                 dword ptr [esi + 0xc], eax
            //   0f8660ffffff         | jbe                 0xffffff66
            //   50                   | push                eax
            //   53                   | push                ebx
            //   6aff                 | push                -1
            //   ff7608               | push                dword ptr [esi + 8]

        $sequence_4 = { 83c408 895f08 837f1400 c7471001000000 }
            // n = 4, score = 100
            //   83c408               | add                 esp, 8
            //   895f08               | mov                 dword ptr [edi + 8], ebx
            //   837f1400             | cmp                 dword ptr [edi + 0x14], 0
            //   c7471001000000       | mov                 dword ptr [edi + 0x10], 1

        $sequence_5 = { 8b01 52 8d95f0d7ffff 52 ff5004 }
            // n = 5, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   52                   | push                edx
            //   8d95f0d7ffff         | lea                 edx, [ebp - 0x2810]
            //   52                   | push                edx
            //   ff5004               | call                dword ptr [eax + 4]

        $sequence_6 = { 8d8424e4010000 6a00 50 e8???????? 83c40c c68424c001000000 }
            // n = 6, score = 100
            //   8d8424e4010000       | lea                 eax, [esp + 0x1e4]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c68424c001000000     | mov                 byte ptr [esp + 0x1c0], 0

        $sequence_7 = { c705????????090400c0 c705????????01000000 c705????????01000000 6a04 58 6bc000 c780f43b420002000000 }
            // n = 7, score = 100
            //   c705????????090400c0     |     
            //   c705????????01000000     |     
            //   c705????????01000000     |     
            //   6a04                 | push                4
            //   58                   | pop                 eax
            //   6bc000               | imul                eax, eax, 0
            //   c780f43b420002000000     | mov    dword ptr [eax + 0x423bf4], 2

        $sequence_8 = { 3bc1 7410 50 e8???????? 83c404 0f1085c0feffff 8b4508 }
            // n = 7, score = 100
            //   3bc1                 | cmp                 eax, ecx
            //   7410                 | je                  0x12
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   0f1085c0feffff       | movups              xmm0, xmmword ptr [ebp - 0x140]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_9 = { 8b7d0c 8bd9 85ff 7417 803e52 750c 807e0145 }
            // n = 7, score = 100
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8bd9                 | mov                 ebx, ecx
            //   85ff                 | test                edi, edi
            //   7417                 | je                  0x19
            //   803e52               | cmp                 byte ptr [esi], 0x52
            //   750c                 | jne                 0xe
            //   807e0145             | cmp                 byte ptr [esi + 1], 0x45

    condition:
        7 of them and filesize < 339968
}