rule win_rifdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rifdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rifdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7404 3bc3 7508 c744242401000000 8d4c2410 }
            // n = 5, score = 200
            //   7404                 | je                  6
            //   3bc3                 | cmp                 eax, ebx
            //   7508                 | jne                 0xa
            //   c744242401000000     | mov                 dword ptr [esp + 0x24], 1
            //   8d4c2410             | lea                 ecx, [esp + 0x10]

        $sequence_1 = { 895c2410 8d442410 50 b808000000 b9???????? e8???????? }
            // n = 6, score = 200
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   50                   | push                eax
            //   b808000000           | mov                 eax, 8
            //   b9????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 56 bf12000000 e8???????? 83c404 }
            // n = 4, score = 200
            //   56                   | push                esi
            //   bf12000000           | mov                 edi, 0x12
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_3 = { c1e006 03048d605d4100 eb05 b8???????? }
            // n = 4, score = 200
            //   c1e006               | shl                 eax, 6
            //   03048d605d4100       | add                 eax, dword ptr [ecx*4 + 0x415d60]
            //   eb05                 | jmp                 7
            //   b8????????           |                     

        $sequence_4 = { 8b4c2408 51 ff15???????? 5f 83c408 c3 }
            // n = 6, score = 200
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   83c408               | add                 esp, 8
            //   c3                   | ret                 

        $sequence_5 = { 6a00 6a12 8d54240c 52 50 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a12                 | push                0x12
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_6 = { 85c0 7518 5e 8b8c2404010000 33cc e8???????? 81c408010000 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   7518                 | jne                 0x1a
            //   5e                   | pop                 esi
            //   8b8c2404010000       | mov                 ecx, dword ptr [esp + 0x104]
            //   33cc                 | xor                 ecx, esp
            //   e8????????           |                     
            //   81c408010000         | add                 esp, 0x108

        $sequence_7 = { 7d0e 885c301c 017e5c 8b465c 3bc1 }
            // n = 5, score = 200
            //   7d0e                 | jge                 0x10
            //   885c301c             | mov                 byte ptr [eax + esi + 0x1c], bl
            //   017e5c               | add                 dword ptr [esi + 0x5c], edi
            //   8b465c               | mov                 eax, dword ptr [esi + 0x5c]
            //   3bc1                 | cmp                 eax, ecx

        $sequence_8 = { 80bd98feffff00 8d8598feffff 740d 8bc8 }
            // n = 4, score = 100
            //   80bd98feffff00       | cmp                 byte ptr [ebp - 0x168], 0
            //   8d8598feffff         | lea                 eax, [ebp - 0x168]
            //   740d                 | je                  0xf
            //   8bc8                 | mov                 ecx, eax

        $sequence_9 = { c1eb10 22d3 8bde 8bc8 }
            // n = 4, score = 100
            //   c1eb10               | shr                 ebx, 0x10
            //   22d3                 | and                 dl, bl
            //   8bde                 | mov                 ebx, esi
            //   8bc8                 | mov                 ecx, eax

        $sequence_10 = { 03c2 8b9540fbffff 89853cfbffff 52 8d8544fbffff }
            // n = 5, score = 100
            //   03c2                 | add                 eax, edx
            //   8b9540fbffff         | mov                 edx, dword ptr [ebp - 0x4c0]
            //   89853cfbffff         | mov                 dword ptr [ebp - 0x4c4], eax
            //   52                   | push                edx
            //   8d8544fbffff         | lea                 eax, [ebp - 0x4bc]

        $sequence_11 = { 8bec 53 56 8b35???????? 57 3b35???????? 7d4a }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi
            //   3b35????????         |                     
            //   7d4a                 | jge                 0x4c

        $sequence_12 = { ff15???????? 85c0 0f85cf000000 803d????????00 b8???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f85cf000000         | jne                 0xd5
            //   803d????????00       |                     
            //   b8????????           |                     

        $sequence_13 = { 5d c3 6a04 8d45dc 50 6a08 }
            // n = 6, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a04                 | push                4
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   6a08                 | push                8

        $sequence_14 = { 33c0 898540bdffff 898544bdffff 898548bdffff 89854cbdffff 8b8558bdffff }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   898540bdffff         | mov                 dword ptr [ebp - 0x42c0], eax
            //   898544bdffff         | mov                 dword ptr [ebp - 0x42bc], eax
            //   898548bdffff         | mov                 dword ptr [ebp - 0x42b8], eax
            //   89854cbdffff         | mov                 dword ptr [ebp - 0x42b4], eax
            //   8b8558bdffff         | mov                 eax, dword ptr [ebp - 0x42a8]

        $sequence_15 = { ff15???????? 8d85e8fbffff 50 8bc8 51 ff15???????? e9???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   8bc8                 | mov                 ecx, eax
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   e9????????           |                     

    condition:
        7 of them and filesize < 212992
}