rule win_rikamanu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rikamanu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rikamanu"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 6a14 ff15???????? a801 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   6a14                 | push                0x14
            //   ff15????????         |                     
            //   a801                 | test                al, 1

        $sequence_1 = { 50 ff15???????? 8b35???????? 3d80969800 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   3d80969800           | cmp                 eax, 0x989680

        $sequence_2 = { 40 3acb 75f9 57 8dbdf4fdffff 2bc2 4f }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   3acb                 | cmp                 cl, bl
            //   75f9                 | jne                 0xfffffffb
            //   57                   | push                edi
            //   8dbdf4fdffff         | lea                 edi, [ebp - 0x20c]
            //   2bc2                 | sub                 eax, edx
            //   4f                   | dec                 edi

        $sequence_3 = { 8d4c2414 51 56 ff15???????? 8b542414 52 }
            // n = 6, score = 100
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   52                   | push                edx

        $sequence_4 = { 0fb6da f68321ae400004 740c ff01 85f6 }
            // n = 5, score = 100
            //   0fb6da               | movzx               ebx, dl
            //   f68321ae400004       | test                byte ptr [ebx + 0x40ae21], 4
            //   740c                 | je                  0xe
            //   ff01                 | inc                 dword ptr [ecx]
            //   85f6                 | test                esi, esi

        $sequence_5 = { 33c0 890d???????? bf???????? 890d???????? 890d???????? 890d???????? }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   890d????????         |                     
            //   bf????????           |                     
            //   890d????????         |                     
            //   890d????????         |                     
            //   890d????????         |                     

        $sequence_6 = { 7423 83c604 803e00 7587 53 57 ff15???????? }
            // n = 7, score = 100
            //   7423                 | je                  0x25
            //   83c604               | add                 esi, 4
            //   803e00               | cmp                 byte ptr [esi], 0
            //   7587                 | jne                 0xffffff89
            //   53                   | push                ebx
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_7 = { 58 668986b8000000 668986be010000 c74668b02f4100 83a6b803000000 6a0d }
            // n = 6, score = 100
            //   58                   | pop                 eax
            //   668986b8000000       | mov                 word ptr [esi + 0xb8], ax
            //   668986be010000       | mov                 word ptr [esi + 0x1be], ax
            //   c74668b02f4100       | mov                 dword ptr [esi + 0x68], 0x412fb0
            //   83a6b803000000       | and                 dword ptr [esi + 0x3b8], 0
            //   6a0d                 | push                0xd

        $sequence_8 = { 83d8ff 85c0 0f841f020000 83c9ff }
            // n = 4, score = 100
            //   83d8ff               | sbb                 eax, -1
            //   85c0                 | test                eax, eax
            //   0f841f020000         | je                  0x225
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_9 = { e8???????? 59 3bc3 7511 391d???????? 7509 ff750c }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   3bc3                 | cmp                 eax, ebx
            //   7511                 | jne                 0x13
            //   391d????????         |                     
            //   7509                 | jne                 0xb
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_10 = { 59 8b7508 8d34f570902400 391e 7404 8bc7 eb6d }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d34f570902400       | lea                 esi, [esi*8 + 0x249070]
            //   391e                 | cmp                 dword ptr [esi], ebx
            //   7404                 | je                  6
            //   8bc7                 | mov                 eax, edi
            //   eb6d                 | jmp                 0x6f

        $sequence_11 = { 33c5 8945fc 8b0d???????? 53 6804010000 33db 8d85f8feffff }
            // n = 7, score = 100
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b0d????????         |                     
            //   53                   | push                ebx
            //   6804010000           | push                0x104
            //   33db                 | xor                 ebx, ebx
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]

        $sequence_12 = { 888800962400 40 ebe9 33c0 8945e4 3d00010000 7d10 }
            // n = 7, score = 100
            //   888800962400         | mov                 byte ptr [eax + 0x249600], cl
            //   40                   | inc                 eax
            //   ebe9                 | jmp                 0xffffffeb
            //   33c0                 | xor                 eax, eax
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   3d00010000           | cmp                 eax, 0x100
            //   7d10                 | jge                 0x12

        $sequence_13 = { 8b842470020000 03f8 57 56 ff15???????? 5f 5e }
            // n = 7, score = 100
            //   8b842470020000       | mov                 eax, dword ptr [esp + 0x270]
            //   03f8                 | add                 edi, eax
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_14 = { ff15???????? 8b8df0fdffff 8b35???????? 51 ffd6 8b95e8fdffff 52 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b8df0fdffff         | mov                 ecx, dword ptr [ebp - 0x210]
            //   8b35????????         |                     
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8b95e8fdffff         | mov                 edx, dword ptr [ebp - 0x218]
            //   52                   | push                edx

        $sequence_15 = { ff35???????? ff15???????? c3 ff35???????? ff742408 }
            // n = 5, score = 100
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   c3                   | ret                 
            //   ff35????????         |                     
            //   ff742408             | push                dword ptr [esp + 8]

        $sequence_16 = { f3a5 8bca 83e103 f3a4 8dbc243c020000 83c9ff f2ae }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8dbc243c020000       | lea                 edi, [esp + 0x23c]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_17 = { 7229 f3a5 ff2495d85a4000 8bc7 ba03000000 83e904 720c }
            // n = 7, score = 100
            //   7229                 | jb                  0x2b
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff2495d85a4000       | jmp                 dword ptr [edx*4 + 0x405ad8]
            //   8bc7                 | mov                 eax, edi
            //   ba03000000           | mov                 edx, 3
            //   83e904               | sub                 ecx, 4
            //   720c                 | jb                  0xe

        $sequence_18 = { ffd6 85c0 74c2 8b85ccfdffff 6aff }
            // n = 5, score = 100
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   74c2                 | je                  0xffffffc4
            //   8b85ccfdffff         | mov                 eax, dword ptr [ebp - 0x234]
            //   6aff                 | push                -1

        $sequence_19 = { f3a5 8bca 6880000000 83e103 6a04 f3a4 }
            // n = 6, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx
            //   6880000000           | push                0x80
            //   83e103               | and                 ecx, 3
            //   6a04                 | push                4
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_20 = { 52 ff15???????? 8b8c2470020000 8bf8 8d442414 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b8c2470020000       | mov                 ecx, dword ptr [esp + 0x270]
            //   8bf8                 | mov                 edi, eax
            //   8d442414             | lea                 eax, [esp + 0x14]

        $sequence_21 = { 53 56 6a01 68???????? e8???????? 6a01 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   56                   | push                esi
            //   6a01                 | push                1
            //   68????????           |                     
            //   e8????????           |                     
            //   6a01                 | push                1

        $sequence_22 = { e8???????? 68ff000000 8d85e9f9ffff 889de8f9ffff 53 50 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   68ff000000           | push                0xff
            //   8d85e9f9ffff         | lea                 eax, [ebp - 0x617]
            //   889de8f9ffff         | mov                 byte ptr [ebp - 0x618], bl
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_23 = { 50 a3???????? e8???????? 8db67c774000 bf???????? a5 a5 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   a3????????           |                     
            //   e8????????           |                     
            //   8db67c774000         | lea                 esi, [esi + 0x40777c]
            //   bf????????           |                     
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]

        $sequence_24 = { c1f905 83e21f 8b0c8de0b84000 f644d10401 7425 50 e8???????? }
            // n = 7, score = 100
            //   c1f905               | sar                 ecx, 5
            //   83e21f               | and                 edx, 0x1f
            //   8b0c8de0b84000       | mov                 ecx, dword ptr [ecx*4 + 0x40b8e0]
            //   f644d10401           | test                byte ptr [ecx + edx*8 + 4], 1
            //   7425                 | je                  0x27
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_25 = { 83c9ff 33c0 8b1d???????? f2ae f7d1 6a00 }
            // n = 6, score = 100
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   8b1d????????         |                     
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   6a00                 | push                0

        $sequence_26 = { 55 6803000010 57 ffd6 3b442410 0f8584040000 b940000000 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   6803000010           | push                0x10000003
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   3b442410             | cmp                 eax, dword ptr [esp + 0x10]
            //   0f8584040000         | jne                 0x48a
            //   b940000000           | mov                 ecx, 0x40

        $sequence_27 = { ff7510 50 ff7508 ff15???????? 5e 5d c21000 }
            // n = 7, score = 100
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c21000               | ret                 0x10

        $sequence_28 = { 56 57 8b7d0c 85db 0f84b2000000 85ff 0f84aa000000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   85db                 | test                ebx, ebx
            //   0f84b2000000         | je                  0xb8
            //   85ff                 | test                edi, edi
            //   0f84aa000000         | je                  0xb0

    condition:
        7 of them and filesize < 212992
}