rule win_rising_sun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rising_sun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rising_sun"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 488d8c2420080000 e9???????? 483b05???????? 750a e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488d8c2420080000     | lea                 ebx, [esp + 0x12a0]
            //   e9????????           |                     
            //   483b05????????       |                     
            //   750a                 | dec                 ecx
            //   e8????????           |                     

        $sequence_1 = { 488b05???????? 4833c4 48898424a0080000 488bd9 488d8c24a1020000 33d2 41b8fb050000 }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   4833c4               | dec                 eax
            //   48898424a0080000     | mov                 ecx, dword ptr [ebp + 0x1b50]
            //   488bd9               | dec                 eax
            //   488d8c24a1020000     | lea                 ecx, [ebp + 0x1350]
            //   33d2                 | dec                 esp
            //   41b8fb050000         | mov                 eax, edi

        $sequence_2 = { 7905 83c8ff eb28 498bc6 4c3b7710 720b b957000780 }
            // n = 7, score = 100
            //   7905                 | dec                 eax
            //   83c8ff               | lea                 edx, [0x16242]
            //   eb28                 | dec                 eax
            //   498bc6               | mov                 dword ptr [esp + 0x450], edi
            //   4c3b7710             | xor                 esi, esi
            //   720b                 | dec                 eax
            //   b957000780           | mov                 edi, ecx

        $sequence_3 = { 42890421 488b442428 83c30f 4863cb 83c308 4a890421 }
            // n = 6, score = 100
            //   42890421             | dec                 edx
            //   488b442428           | stc                 
            //   83c30f               | mov                 dword ptr [ebp + 0x58], 0x835d2858
            //   4863cb               | mov                 dword ptr [ebp + 0x5c], 0x9c927bb1
            //   83c308               | mov                 dword ptr [ebp + 0x60], 0xf2b0f7d
            //   4a890421             | mov                 dword ptr [ebp + 0x64], 0x1f4122ad

        $sequence_4 = { e8???????? 48c744247000010000 4c89642448 4c89642450 488bfe 4c89642420 4885ff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   48c744247000010000     | mov    ecx, esp
            //   4c89642448           | inc                 ebp
            //   4c89642450           | xor                 eax, eax
            //   488bfe               | mov                 edx, eax
            //   4c89642420           | dec                 ecx
            //   4885ff               | mov                 ecx, esp

        $sequence_5 = { 488b8828010000 488b01 8a08 880a 33c9 4c8d058e760000 388c2498000000 }
            // n = 7, score = 100
            //   488b8828010000       | dec                 eax
            //   488b01               | mov                 dword ptr [edx + ecx*8 + 8], eax
            //   8a08                 | mov                 edx, 0x11
            //   880a                 | int3                
            //   33c9                 | dec                 eax
            //   4c8d058e760000       | mov                 eax, dword ptr [edi + 8]
            //   388c2498000000       | dec                 eax

        $sequence_6 = { 488985e0080000 448bea 488bd9 c744245018d32263 c744245407137a55 c744245883e85ad2 c744245cee3ed142 }
            // n = 7, score = 100
            //   488985e0080000       | inc                 ecx
            //   448bea               | mov                 eax, 8
            //   488bd9               | dec                 eax
            //   c744245018d32263     | mov                 ecx, dword ptr [ebp + 0xd40]
            //   c744245407137a55     | dec                 eax
            //   c744245883e85ad2     | lea                 edx, [0x16dca]
            //   c744245cee3ed142     | dec                 eax

        $sequence_7 = { 4c89642458 4c89642460 4c89642468 4c89642470 4c89642478 44896580 4489642440 }
            // n = 7, score = 100
            //   4c89642458           | jmp                 0x1977
            //   4c89642460           | movzx               eax, bl
            //   4c89642468           | inc                 edx
            //   4c89642470           | movzx               eax, byte ptr [eax + esi]
            //   4c89642478           | inc                 ecx
            //   44896580             | mov                 byte ptr [eax + ebp + 2], al
            //   4489642440           | inc                 ecx

        $sequence_8 = { c74538a9bcad89 c7453ca6ac81a6 c74540a1bca1a9 c74544a4a1b2ad c745489ba1acc8 c7454cc8c8c8c8 }
            // n = 6, score = 100
            //   c74538a9bcad89       | dec                 esp
            //   c7453ca6ac81a6       | mov                 eax, dword ptr [ebp - 0x51]
            //   c74540a1bca1a9       | dec                 eax
            //   c74544a4a1b2ad       | mov                 ecx, dword ptr [ebp - 0x59]
            //   c745489ba1acc8       | dec                 esp
            //   c7454cc8c8c8c8       | lea                 ebx, [ebp - 0x71]

        $sequence_9 = { eb39 6683f93f 0f8510040000 4883c002 }
            // n = 4, score = 100
            //   eb39                 | mov                 dword ptr [ebp + 0x50], 0x8486140d
            //   6683f93f             | mov                 dword ptr [ebp + 0x54], 0x64cbf418
            //   0f8510040000         | mov                 dword ptr [ebp + 0x58], 0x44f4d402
            //   4883c002             | mov                 dword ptr [ebp + 0x4c], 0x9e57613d

    condition:
        7 of them and filesize < 409600
}