rule win_rm3_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rm3."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rm3"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b483c 03c8 0fb74106 8365f800 }
            // n = 4, score = 2300
            //   8b483c               | cmp                 edi, eax
            //   03c8                 | jbe                 0xf
            //   0fb74106             | mov                 eax, dword ptr [ecx + 0x3c]
            //   8365f800             | lea                 edx, [eax + ebx - 1]

        $sequence_1 = { 897104 8b4808 ff7004 034c240c 8b00 51 }
            // n = 6, score = 2300
            //   897104               | mov                 ebp, edx
            //   8b4808               | dec                 esp
            //   ff7004               | lea                 ecx, [eax - 0x28]
            //   034c240c             | inc                 ecx
            //   8b00                 | push                ebp
            //   51                   | inc                 ecx

        $sequence_2 = { 7303 8975f8 8b45f8 83c628 ff4dfc 85c0 7505 }
            // n = 7, score = 2300
            //   7303                 | cmp                 al, 2
            //   8975f8               | dec                 esp
            //   8b45f8               | lea                 eax, [ebx + edi - 0x80]
            //   83c628               | dec                 eax
            //   ff4dfc               | lea                 ecx, [eax - 0x48]
            //   85c0                 | dec                 eax
            //   7505                 | lea                 edx, [eax - 0x68]

        $sequence_3 = { 53 8945fc 0fb74114 56 57 8d740818 }
            // n = 6, score = 2300
            //   53                   | dec                 esp
            //   8945fc               | mov                 esp, eax
            //   0fb74114             | jae                 0x15
            //   56                   | bt                  dword ptr [esi], 0x1f
            //   57                   | setb                al
            //   8d740818             | neg                 al

        $sequence_4 = { 8b4508 3b460c 7247 8b7938 8b4608 8b513c }
            // n = 6, score = 2300
            //   8b4508               | mov                 dword ptr [ecx + 4], esi
            //   3b460c               | mov                 ecx, dword ptr [eax + 8]
            //   7247                 | push                dword ptr [eax + 4]
            //   8b7938               | add                 ecx, dword ptr [esp + 0xc]
            //   8b4608               | mov                 eax, dword ptr [eax]
            //   8b513c               | push                ecx

        $sequence_5 = { 56 57 8d740818 8b4508 3b460c 7247 }
            // n = 6, score = 2300
            //   56                   | push                esi
            //   57                   | inc                 ecx
            //   8d740818             | push                edi
            //   8b4508               | dec                 eax
            //   3b460c               | sub                 esp, 0x20
            //   7247                 | inc                 esp

        $sequence_6 = { 8b460c 03c2 394508 7303 8975f8 8b45f8 }
            // n = 6, score = 2300
            //   8b460c               | test                eax, eax
            //   03c2                 | je                  0x100
            //   394508               | mov                 ecx, dword ptr [esp + 0x70]
            //   7303                 | dec                 eax
            //   8975f8               | sub                 esp, 0x50
            //   8b45f8               | inc                 ecx

        $sequence_7 = { f7d2 23fa 3bf8 7609 8b413c 8d5418ff }
            // n = 6, score = 2300
            //   f7d2                 | mov                 esi, eax
            //   23fa                 | dec                 ecx
            //   3bf8                 | mov                 edi, ecx
            //   7609                 | dec                 ebp
            //   8b413c               | mov                 eax, dword ptr [eax + 0xc8]
            //   8d5418ff             | dec                 eax

        $sequence_8 = { 8bec 51 837d0804 53 56 6a57 }
            // n = 6, score = 1800
            //   8bec                 | not                 edx
            //   51                   | and                 edi, edx
            //   837d0804             | cmp                 edi, eax
            //   53                   | jbe                 0xf
            //   56                   | add                 esi, 0x28
            //   6a57                 | dec                 dword ptr [ebp - 4]

        $sequence_9 = { 8bf0 6a08 8d7e10 5a 8bc7 8d4df8 e8???????? }
            // n = 7, score = 1800
            //   8bf0                 | cmp                 dword ptr [ebp + 8], 4
            //   6a08                 | push                ebx
            //   8d7e10               | push                esi
            //   5a                   | push                0x57
            //   8bc7                 | push                esi
            //   8d4df8               | push                edi
            //   e8????????           |                     

        $sequence_10 = { 56 57 8bd8 8bf9 8db5f0feffff 8bce 8d041b }
            // n = 7, score = 1800
            //   56                   | test                eax, eax
            //   57                   | jne                 9
            //   8bd8                 | cmp                 dword ptr [ebp - 4], eax
            //   8bf9                 | jne                 0xffffffa8
            //   8db5f0feffff         | mov                 eax, dword ptr [ecx + 0x38]
            //   8bce                 | mov                 edx, dword ptr [esi + 8]
            //   8d041b               | lea                 edx, [eax + edx - 1]

        $sequence_11 = { 8bc6 e8???????? 56 ff7510 8d8df4feffff 51 ff7508 }
            // n = 7, score = 1800
            //   8bc6                 | dec                 eax
            //   e8????????           |                     
            //   56                   | not                 eax
            //   ff7510               | and                 edx, eax
            //   8d8df4feffff         | mov                 eax, dword ptr [esi + 0xc]
            //   51                   | add                 eax, edx
            //   ff7508               | cmp                 dword ptr [ebp + 8], eax

        $sequence_12 = { 51 8365fc00 56 8d4508 50 6a08 }
            // n = 6, score = 1800
            //   51                   | lea                 edi, [ebx + edx - 1]
            //   8365fc00             | dec                 edx
            //   56                   | not                 edx
            //   8d4508               | and                 edi, edx
            //   50                   | mov                 ebp, esp
            //   6a08                 | push                ecx

        $sequence_13 = { e8???????? ff7518 8d8578ffffff 50 50 8bc8 e8???????? }
            // n = 7, score = 1800
            //   e8????????           |                     
            //   ff7518               | push                esi
            //   8d8578ffffff         | push                ebp
            //   50                   | mov                 ebp, esp
            //   50                   | push                ecx
            //   8bc8                 | push                ecx
            //   e8????????           |                     

        $sequence_14 = { 8d856cfeffff ff750c 8d8de8fdffff 50 e8???????? ff7518 }
            // n = 6, score = 1800
            //   8d856cfeffff         | dec                 eax
            //   ff750c               | not                 eax
            //   8d8de8fdffff         | and                 edx, eax
            //   50                   | mov                 eax, dword ptr [esi + 0xc]
            //   e8????????           |                     
            //   ff7518               | lea                 edx, [eax + edx - 1]

        $sequence_15 = { 8bc6 e8???????? 6a58 6a00 56 e8???????? 83c40c }
            // n = 7, score = 1800
            //   8bc6                 | movzx               eax, word ptr [ecx + 6]
            //   e8????????           |                     
            //   6a58                 | and                 dword ptr [ebp - 8], 0
            //   6a00                 | push                ebx
            //   56                   | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   83c40c               | movzx               eax, word ptr [ecx + 0x14]

        $sequence_16 = { 4883ec30 488b05???????? 4c8ba42480000000 498bf1 4c8b90b0000000 }
            // n = 5, score = 300
            //   4883ec30             | inc                 esp
            //   488b05????????       |                     
            //   4c8ba42480000000     | mov                 ecx, esi
            //   498bf1               | dec                 eax
            //   4c8b90b0000000       | mov                 eax, ebx

        $sequence_17 = { 4833d0 488bc2 48c1e81b 4833d0 488bc2 480fafc3 488901 }
            // n = 7, score = 300
            //   4833d0               | dec                 eax
            //   488bc2               | shr                 eax, 0xc
            //   48c1e81b             | dec                 eax
            //   4833d0               | xor                 ebx, eax
            //   488bc2               | dec                 eax
            //   480fafc3             | mov                 eax, ebx
            //   488901               | dec                 eax

        $sequence_18 = { 4883ec50 418bf0 4c8b05???????? 498bf9 4d8b80c8000000 488bea 4c8d48d8 }
            // n = 7, score = 300
            //   4883ec50             | shr                 eax, 0x1b
            //   418bf0               | dec                 eax
            //   4c8b05????????       |                     
            //   498bf9               | xor                 edx, eax
            //   4d8b80c8000000       | dec                 eax
            //   488bea               | mov                 eax, edx
            //   4c8d48d8             | dec                 eax

        $sequence_19 = { 4c8d443b80 488d48b8 488d5098 e8???????? 85c0 0f84f0000000 8b4c2470 }
            // n = 7, score = 300
            //   4c8d443b80           | mov                 edx, dword ptr [eax + 0xb0]
            //   488d48b8             | dec                 eax
            //   488d5098             | xor                 edx, eax
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f84f0000000         | mov                 eax, edx
            //   8b4c2470             | dec                 eax

        $sequence_20 = { 3c41 7204 3c5a 763e 3c61 7204 3c7a }
            // n = 7, score = 300
            //   3c41                 | shl                 eax, 0x19
            //   7204                 | dec                 eax
            //   3c5a                 | xor                 ebx, eax
            //   763e                 | dec                 eax
            //   3c61                 | mov                 eax, ebx
            //   7204                 | dec                 eax
            //   3c7a                 | sub                 esp, 0x30

        $sequence_21 = { ff15???????? 85c0 8bd8 0f8560020000 8a442431 3c02 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   85c0                 | dec                 esp
            //   8bd8                 | mov                 esp, dword ptr [esp + 0x80]
            //   0f8560020000         | dec                 ecx
            //   8a442431             | mov                 esi, ecx
            //   3c02                 | dec                 esp

        $sequence_22 = { 4885c0 488bd8 742f 8d4f01 448bce }
            // n = 5, score = 300
            //   4885c0               | inc                 ebp
            //   488bd8               | mov                 eax, esp
            //   742f                 | dec                 eax
            //   8d4f01               | mov                 edx, ebp
            //   448bce               | dec                 eax

        $sequence_23 = { 488bc3 48c1e80c 4833d8 488bc3 48c1e019 4833d8 488bc3 }
            // n = 7, score = 300
            //   488bc3               | mov                 ecx, edi
            //   48c1e80c             | dec                 eax
            //   4833d8               | test                eax, eax
            //   488bc3               | dec                 eax
            //   48c1e019             | mov                 ebx, eax
            //   4833d8               | je                  0x31
            //   488bc3               | lea                 ecx, [edi + 1]

        $sequence_24 = { eb0a 8b45ec 83c410 5e 5f }
            // n = 5, score = 100
            //   eb0a                 | lea                 edx, [eax + edx - 1]
            //   8b45ec               | dec                 eax
            //   83c410               | not                 eax
            //   5e                   | and                 edx, eax
            //   5f                   | mov                 eax, dword ptr [esi + 0xc]

        $sequence_25 = { 8945e8 7442 ebcf 8b45dc b931000000 8b15???????? }
            // n = 6, score = 100
            //   8945e8               | push                ebx
            //   7442                 | mov                 dword ptr [ebp - 4], eax
            //   ebcf                 | movzx               eax, word ptr [ecx + 0x14]
            //   8b45dc               | push                esi
            //   b931000000           | push                edi
            //   8b15????????         |                     

        $sequence_26 = { 83ec28 31c0 31c9 8945fc }
            // n = 4, score = 100
            //   83ec28               | cmp                 eax, dword ptr [esi + 0xc]
            //   31c0                 | jb                  0x53
            //   31c9                 | mov                 edi, dword ptr [ecx + 0x38]
            //   8945fc               | lea                 eax, [eax + edi - 1]

        $sequence_27 = { e8???????? 8d0d84308702 31d2 8b75f0 89460c 890c24 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d0d84308702         | mov                 eax, dword ptr [ecx + 0x3c]
            //   31d2                 | lea                 edx, [eax + ebx - 1]
            //   8b75f0               | jmp                 0x13
            //   89460c               | mov                 eax, dword ptr [ecx + 0x38]
            //   890c24               | mov                 edx, dword ptr [esi + 8]

        $sequence_28 = { 8b4dec 89c2 83c201 89ce }
            // n = 4, score = 100
            //   8b4dec               | mov                 esi, dword ptr [eax + 4]
            //   89c2                 | mov                 dword ptr [ecx + 4], esi
            //   83c201               | mov                 ecx, dword ptr [eax + 8]
            //   89ce                 | push                dword ptr [eax + 4]

        $sequence_29 = { 31c9 ba03000000 8d75f1 83ec0c }
            // n = 4, score = 100
            //   31c9                 | dec                 edx
            //   ba03000000           | not                 edx
            //   8d75f1               | and                 edi, edx
            //   83ec0c               | cmp                 edi, eax

        $sequence_30 = { 8d95f1fbffff c785ecfbffff00000000 8db5ecfbffff 8b3d???????? 56 68ff030000 52 }
            // n = 7, score = 100
            //   8d95f1fbffff         | jbe                 0x12
            //   c785ecfbffff00000000     | mov    ecx, dword ptr [eax + 0x3c]
            //   8db5ecfbffff         | add                 ecx, eax
            //   8b3d????????         |                     
            //   56                   | movzx               eax, word ptr [ecx + 6]
            //   68ff030000           | and                 dword ptr [ebp - 8], 0
            //   52                   | mov                 eax, dword ptr [ebp + 8]

        $sequence_31 = { 8995d8fbffff 89b5d4fbffff e8???????? 83c40c 8b85d4fbffff 50 e8???????? }
            // n = 7, score = 100
            //   8995d8fbffff         | lea                 edx, [eax + edx - 1]
            //   89b5d4fbffff         | push                esi
            //   e8????????           |                     
            //   83c40c               | push                edi
            //   8b85d4fbffff         | lea                 esi, [eax + ecx + 0x18]
            //   50                   | mov                 eax, dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_32 = { 8b7138 891424 c744240400000000 89742408 8945dc e8???????? 8b45e0 }
            // n = 7, score = 100
            //   8b7138               | add                 ecx, dword ptr [esp + 0xc]
            //   891424               | jmp                 0xc
            //   c744240400000000     | mov                 eax, dword ptr [ecx + 0x38]
            //   89742408             | mov                 edx, dword ptr [esi + 8]
            //   8945dc               | lea                 edx, [eax + edx - 1]
            //   e8????????           |                     
            //   8b45e0               | movzx               eax, word ptr [ecx + 6]

        $sequence_33 = { 894de0 0f84ca000000 8b45cc 8b08 8b55ec 035010 }
            // n = 6, score = 100
            //   894de0               | mov                 edx, dword ptr [ecx + 0x3c]
            //   0f84ca000000         | mov                 ebx, dword ptr [esi + 0x10]
            //   8b45cc               | lea                 eax, [eax + edi - 1]
            //   8b08                 | dec                 edi
            //   8b55ec               | movzx               eax, word ptr [ecx + 6]
            //   035010               | and                 dword ptr [ebp - 8], 0

        $sequence_34 = { 8b4048 8945b0 8b45b4 8b4040 8945ac }
            // n = 5, score = 100
            //   8b4048               | mov                 edx, dword ptr [ecx + 0x3c]
            //   8945b0               | mov                 ebx, dword ptr [esi + 0x10]
            //   8b45b4               | lea                 eax, [eax + edi - 1]
            //   8b4040               | dec                 edi
            //   8945ac               | mov                 dword ptr [ecx], esi

        $sequence_35 = { 51 ffd0 8b0d???????? 8b95e4fbffff }
            // n = 4, score = 100
            //   51                   | dec                 edi
            //   ffd0                 | not                 edi
            //   8b0d????????         |                     
            //   8b95e4fbffff         | and                 eax, edi

        $sequence_36 = { 8b8dccfbffff 51 8bb5e0fbffff 56 }
            // n = 4, score = 100
            //   8b8dccfbffff         | push                dword ptr [eax + 4]
            //   51                   | add                 ecx, dword ptr [esp + 0xc]
            //   8bb5e0fbffff         | mov                 eax, dword ptr [eax]
            //   56                   | lea                 edi, [ebx + edx - 1]

        $sequence_37 = { 89442404 c744240800000000 8954240c 8b4590 894d80 ffd0 }
            // n = 6, score = 100
            //   89442404             | mov                 esi, dword ptr [eax + 4]
            //   c744240800000000     | mov                 dword ptr [ecx + 4], esi
            //   8954240c             | mov                 ecx, dword ptr [eax + 8]
            //   8b4590               | push                dword ptr [eax + 4]
            //   894d80               | add                 ecx, dword ptr [esp + 0xc]
            //   ffd0                 | mov                 eax, dword ptr [eax]

        $sequence_38 = { 89cf 83c710 89957cffffff 898d78ffffff 89bd74ffffff 89b570ffffff }
            // n = 6, score = 100
            //   89cf                 | and                 dword ptr [ebp - 8], 0
            //   83c710               | push                ebx
            //   89957cffffff         | mov                 dword ptr [ebp - 4], eax
            //   898d78ffffff         | movzx               eax, word ptr [ecx + 0x14]
            //   89bd74ffffff         | push                esi
            //   89b570ffffff         | push                edi

        $sequence_39 = { 890c24 c744240400000000 8955dc e8???????? 8d0d77318702 890424 894c2404 }
            // n = 7, score = 100
            //   890c24               | push                esi
            //   c744240400000000     | push                edi
            //   8955dc               | lea                 esi, [eax + ecx + 0x18]
            //   e8????????           |                     
            //   8d0d77318702         | mov                 eax, dword ptr [ebp + 8]
            //   890424               | mov                 dword ptr [ecx + 4], esi
            //   894c2404             | mov                 ecx, dword ptr [eax + 8]

    condition:
        7 of them and filesize < 221184
}