rule win_rockloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rockloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rockloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { dc4dec 83650800 dec9 dd5dec dd45ec dd5918 9b }
            // n = 7, score = 300
            //   dc4dec               | fmul                qword ptr [ebp - 0x14]
            //   83650800             | and                 dword ptr [ebp + 8], 0
            //   dec9                 | fmulp               st(1)
            //   dd5dec               | fstp                qword ptr [ebp - 0x14]
            //   dd45ec               | fld                 qword ptr [ebp - 0x14]
            //   dd5918               | fstp                qword ptr [ecx + 0x18]
            //   9b                   | wait                

        $sequence_1 = { 40 8a0c30 3acb 75f3 8a0c30 3acb 7413 }
            // n = 7, score = 300
            //   40                   | inc                 eax
            //   8a0c30               | mov                 cl, byte ptr [eax + esi]
            //   3acb                 | cmp                 cl, bl
            //   75f3                 | jne                 0xfffffff5
            //   8a0c30               | mov                 cl, byte ptr [eax + esi]
            //   3acb                 | cmp                 cl, bl
            //   7413                 | je                  0x15

        $sequence_2 = { c3 80f961 7c0d 80f966 7f08 0fbec9 8d44c1a9 }
            // n = 7, score = 300
            //   c3                   | ret                 
            //   80f961               | cmp                 cl, 0x61
            //   7c0d                 | jl                  0xf
            //   80f966               | cmp                 cl, 0x66
            //   7f08                 | jg                  0xa
            //   0fbec9               | movsx               ecx, cl
            //   8d44c1a9             | lea                 eax, [ecx + eax*8 - 0x57]

        $sequence_3 = { c0e204 240f 02d0 8817 }
            // n = 4, score = 300
            //   c0e204               | shl                 dl, 4
            //   240f                 | and                 al, 0xf
            //   02d0                 | add                 dl, al
            //   8817                 | mov                 byte ptr [edi], dl

        $sequence_4 = { 80383a 75b7 40 e8???????? 50 }
            // n = 5, score = 300
            //   80383a               | cmp                 byte ptr [eax], 0x3a
            //   75b7                 | jne                 0xffffffb9
            //   40                   | inc                 eax
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_5 = { 46 80382d 750a dd05???????? 40 dd5de4 }
            // n = 6, score = 300
            //   46                   | inc                 esi
            //   80382d               | cmp                 byte ptr [eax], 0x2d
            //   750a                 | jne                 0xc
            //   dd05????????         |                     
            //   40                   | inc                 eax
            //   dd5de4               | fstp                qword ptr [ebp - 0x1c]

        $sequence_6 = { 7f09 0fbec9 8d44c1d0 eb24 80f941 7c0e 80f946 }
            // n = 7, score = 300
            //   7f09                 | jg                  0xb
            //   0fbec9               | movsx               ecx, cl
            //   8d44c1d0             | lea                 eax, [ecx + eax*8 - 0x30]
            //   eb24                 | jmp                 0x26
            //   80f941               | cmp                 cl, 0x41
            //   7c0e                 | jl                  0x10
            //   80f946               | cmp                 cl, 0x46

        $sequence_7 = { 5d c20400 e8???????? 85c0 7407 c7400c05000000 c3 }
            // n = 7, score = 300
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   c7400c05000000       | mov                 dword ptr [eax + 0xc], 5
            //   c3                   | ret                 

        $sequence_8 = { 6a02 58 e8???????? 8bf8 85ff 0f84a9feffff 837d1000 }
            // n = 7, score = 300
            //   6a02                 | push                2
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f84a9feffff         | je                  0xfffffeaf
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0

        $sequence_9 = { 48 746a 48 744e }
            // n = 4, score = 300
            //   48                   | dec                 eax
            //   746a                 | je                  0x6c
            //   48                   | dec                 eax
            //   744e                 | je                  0x50

    condition:
        7 of them and filesize < 98304
}