rule win_rofin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rofin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rofin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f804 753f 8b11 8a02 3c30 7507 8b5108 }
            // n = 7, score = 100
            //   83f804               | cmp                 eax, 4
            //   753f                 | jne                 0x41
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   3c30                 | cmp                 al, 0x30
            //   7507                 | jne                 9
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]

        $sequence_1 = { 837c241801 7407 33db e9???????? 6a00 6a00 56 }
            // n = 7, score = 100
            //   837c241801           | cmp                 dword ptr [esp + 0x18], 1
            //   7407                 | je                  9
            //   33db                 | xor                 ebx, ebx
            //   e9????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi

        $sequence_2 = { 56 57 8b7c2414 33c0 33f6 85ff }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   33c0                 | xor                 eax, eax
            //   33f6                 | xor                 esi, esi
            //   85ff                 | test                edi, edi

        $sequence_3 = { e8???????? 8bf0 83c404 803e00 7453 6a0a }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   803e00               | cmp                 byte ptr [esi], 0
            //   7453                 | je                  0x55
            //   6a0a                 | push                0xa

        $sequence_4 = { 8a4802 84c9 743f 8a4801 84c9 750e 8a4802 }
            // n = 7, score = 100
            //   8a4802               | mov                 cl, byte ptr [eax + 2]
            //   84c9                 | test                cl, cl
            //   743f                 | je                  0x41
            //   8a4801               | mov                 cl, byte ptr [eax + 1]
            //   84c9                 | test                cl, cl
            //   750e                 | jne                 0x10
            //   8a4802               | mov                 cl, byte ptr [eax + 2]

        $sequence_5 = { 56 3b0d???????? 57 7358 8bc1 c1f805 8d3c85209e4200 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   3b0d????????         |                     
            //   57                   | push                edi
            //   7358                 | jae                 0x5a
            //   8bc1                 | mov                 eax, ecx
            //   c1f805               | sar                 eax, 5
            //   8d3c85209e4200       | lea                 edi, [eax*4 + 0x429e20]

        $sequence_6 = { 45 f2ae 8b442410 f7d1 2bf9 83c00d 8bd1 }
            // n = 7, score = 100
            //   45                   | inc                 ebp
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   83c00d               | add                 eax, 0xd
            //   8bd1                 | mov                 edx, ecx

        $sequence_7 = { 89b42434010000 c744242800000000 ff15???????? 8d4c2418 51 56 e8???????? }
            // n = 7, score = 100
            //   89b42434010000       | mov                 dword ptr [esp + 0x134], esi
            //   c744242800000000     | mov                 dword ptr [esp + 0x28], 0
            //   ff15????????         |                     
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_8 = { 59 c3 8b8d90fcffff e9???????? 8b8d90fcffff 81c168030000 e9???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   8b8d90fcffff         | mov                 ecx, dword ptr [ebp - 0x370]
            //   e9????????           |                     
            //   8b8d90fcffff         | mov                 ecx, dword ptr [ebp - 0x370]
            //   81c168030000         | add                 ecx, 0x368
            //   e9????????           |                     

        $sequence_9 = { 8b442424 6a40 68???????? 50 e8???????? 83c41c 5f }
            // n = 7, score = 100
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   6a40                 | push                0x40
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 409600
}