rule win_rokku_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rokku."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rokku"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0bd0 c1e90e 8b442418 0bf1 33442444 }
            // n = 5, score = 200
            //   0bd0                 | or                  edx, eax
            //   c1e90e               | shr                 ecx, 0xe
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   0bf1                 | or                  esi, ecx
            //   33442444             | xor                 eax, dword ptr [esp + 0x44]

        $sequence_1 = { c1fb1a 01442420 8b442430 1154241c f76c2438 01442420 8b44246c }
            // n = 7, score = 200
            //   c1fb1a               | sar                 ebx, 0x1a
            //   01442420             | add                 dword ptr [esp + 0x20], eax
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   1154241c             | adc                 dword ptr [esp + 0x1c], edx
            //   f76c2438             | imul                dword ptr [esp + 0x38]
            //   01442420             | add                 dword ptr [esp + 0x20], eax
            //   8b44246c             | mov                 eax, dword ptr [esp + 0x6c]

        $sequence_2 = { 8d54240c e8???????? a3???????? 33c0 c744240c5d786f7a c74424106b4c6f72 66c74424146b00 }
            // n = 7, score = 200
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   e8????????           |                     
            //   a3????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c744240c5d786f7a     | mov                 dword ptr [esp + 0xc], 0x7a6f785d
            //   c74424106b4c6f72     | mov                 dword ptr [esp + 0x10], 0x726f4c6b
            //   66c74424146b00       | mov                 word ptr [esp + 0x14], 0x6b

        $sequence_3 = { 03d0 33ca 8954242c 8b542428 c1c10c 03d1 }
            // n = 6, score = 200
            //   03d0                 | add                 edx, eax
            //   33ca                 | xor                 ecx, edx
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx
            //   8b542428             | mov                 edx, dword ptr [esp + 0x28]
            //   c1c10c               | rol                 ecx, 0xc
            //   03d1                 | add                 edx, ecx

        $sequence_4 = { 8bf1 89742408 85f6 745d 53 8b1e 57 }
            // n = 7, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   89742408             | mov                 dword ptr [esp + 8], esi
            //   85f6                 | test                esi, esi
            //   745d                 | je                  0x5f
            //   53                   | push                ebx
            //   8b1e                 | mov                 ebx, dword ptr [esi]
            //   57                   | push                edi

        $sequence_5 = { 83f917 72f0 8b0d???????? 88542439 8d542422 e8???????? }
            // n = 6, score = 200
            //   83f917               | cmp                 ecx, 0x17
            //   72f0                 | jb                  0xfffffff2
            //   8b0d????????         |                     
            //   88542439             | mov                 byte ptr [esp + 0x39], dl
            //   8d542422             | lea                 edx, [esp + 0x22]
            //   e8????????           |                     

        $sequence_6 = { 8d7d28 53 8d5328 8bcf e8???????? 8b742448 83c550 }
            // n = 7, score = 200
            //   8d7d28               | lea                 edi, [ebp + 0x28]
            //   53                   | push                ebx
            //   8d5328               | lea                 edx, [ebx + 0x28]
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b742448             | mov                 esi, dword ptr [esp + 0x48]
            //   83c550               | add                 ebp, 0x50

        $sequence_7 = { 894a0c 8b4c2420 0fa4c11a 8b4c2410 c1e01a 2bc8 8b842488000000 }
            // n = 7, score = 200
            //   894a0c               | mov                 dword ptr [edx + 0xc], ecx
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   0fa4c11a             | shld                ecx, eax, 0x1a
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   c1e01a               | shl                 eax, 0x1a
            //   2bc8                 | sub                 ecx, eax
            //   8b842488000000       | mov                 eax, dword ptr [esp + 0x88]

        $sequence_8 = { 7517 8b0e 68???????? e8???????? 33c9 84c0 0f45cf }
            // n = 7, score = 200
            //   7517                 | jne                 0x19
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   68????????           |                     
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   84c0                 | test                al, al
            //   0f45cf               | cmovne              ecx, edi

        $sequence_9 = { 41 83f905 7305 8a55ee ebee }
            // n = 5, score = 200
            //   41                   | inc                 ecx
            //   83f905               | cmp                 ecx, 5
            //   7305                 | jae                 7
            //   8a55ee               | mov                 dl, byte ptr [ebp - 0x12]
            //   ebee                 | jmp                 0xfffffff0

    condition:
        7 of them and filesize < 548864
}