rule win_romcom_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.romcom_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.romcom_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33d2 448d4240 488d8d60100000 e8???????? 488d0d9a6e0100 e8???????? 4c8bc0 }
            // n = 7, score = 100
            //   33d2                 | dec                 esp
            //   448d4240             | mov                 eax, eax
            //   488d8d60100000       | lea                 esi, [edi + 1]
            //   e8????????           |                     
            //   488d0d9a6e0100       | dec                 eax
            //   e8????????           |                     
            //   4c8bc0               | sub                 ecx, esi

        $sequence_1 = { 488945a0 488d0592d20400 4885db 7424 83630800 488903 }
            // n = 6, score = 100
            //   488945a0             | mov                 dword ptr [esp + 0x40], 0x4f004e
            //   488d0592d20400       | mov                 dword ptr [esp + 0x30], 0xc
            //   4885db               | inc                 ecx
            //   7424                 | mov                 ebx, 0x32
            //   83630800             | mov                 dword ptr [esp + 0x34], 0x31383b32
            //   488903               | mov                 dword ptr [esp + 0x38], 0x3a363837

        $sequence_2 = { c7442434323b3831 c74424383738363a c744243c02005b00 c74424407e006900 c744244461005d00 c74424485e005200 c744244c52005400 }
            // n = 7, score = 100
            //   c7442434323b3831     | inc                 ecx
            //   c74424383738363a     | lea                 edx, [ecx + 0x1b]
            //   c744243c02005b00     | inc                 ecx
            //   c74424407e006900     | lea                 ecx, [ebp - 0x1000]
            //   c744244461005d00     | dec                 esp
            //   c74424485e005200     | mov                 dword ptr [esp + 0x30], edi
            //   c744244c52005400     | test                edi, edi

        $sequence_3 = { f30f7f458f 482bf3 4889742420 4c8d458f 488d55a7 498bce e8???????? }
            // n = 7, score = 100
            //   f30f7f458f           | dec                 eax
            //   482bf3               | mov                 ecx, ebx
            //   4889742420           | nop                 
            //   4c8d458f             | dec                 eax
            //   488d55a7             | lea                 eax, [0x40098]
            //   498bce               | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 488d8a50000000 e9???????? 4055 4883ec20 488bea 8b8598000000 83e002 }
            // n = 7, score = 100
            //   488d8a50000000       | mov                 ebp, edx
            //   e9????????           |                     
            //   4055                 | mov                 edx, 0x458
            //   4883ec20             | dec                 eax
            //   488bea               | mov                 ecx, dword ptr [ebp + 0x78]
            //   8b8598000000         | ret                 
            //   83e002               | inc                 esp

        $sequence_5 = { eb24 488d152e6b0600 488d4b02 483bce 7714 41803c1f30 750d }
            // n = 7, score = 100
            //   eb24                 | add                 ecx, esi
            //   488d152e6b0600       | inc                 esp
            //   488d4b02             | lea                 esp, [esi + 1]
            //   483bce               | mov                 ecx, 0x202
            //   7714                 | mov                 dword ptr [ebp + 0xf40], 0x10
            //   41803c1f30           | dec                 eax
            //   750d                 | lea                 edx, [ebp + 0xf70]

        $sequence_6 = { c7442460474e595a c7442464080a5d0d c74424685b5a4659 c744246c10475f51 c7442470141e5e19 c74424744b4b5f4f c744247848262600 }
            // n = 7, score = 100
            //   c7442460474e595a     | test                eax, eax
            //   c7442464080a5d0d     | jne                 0x97
            //   c74424685b5a4659     | and                 dword ptr [esp + 0x3c], eax
            //   c744246c10475f51     | inc                 ecx
            //   c7442470141e5e19     | mov                 ecx, 0x41
            //   c74424744b4b5f4f     | dec                 esp
            //   c744247848262600     | lea                 eax, [ebp + 0x1060]

        $sequence_7 = { 498bd6 498bcd ff5038 498b4740 488b4808 48894d97 488b01 }
            // n = 7, score = 100
            //   498bd6               | mov                 ecx, esi
            //   498bcd               | dec                 eax
            //   ff5038               | mov                 ecx, esi
            //   498b4740             | jmp                 0x102c
            //   488b4808             | xor                 ecx, ecx
            //   48894d97             | dec                 eax
            //   488b01               | mov                 dword ptr [eax], ecx

        $sequence_8 = { ebd7 488d053e4d0300 ba80000000 0f1000 410f1106 0f104810 410f114e10 }
            // n = 7, score = 100
            //   ebd7                 | xor                 cl, dl
            //   488d053e4d0300       | dec                 eax
            //   ba80000000           | cmp                 ecx, edx
            //   0f1000               | jae                 0x1979
            //   410f1106             | dec                 eax
            //   0f104810             | lea                 eax, [ecx + 1]
            //   410f114e10           | dec                 eax

        $sequence_9 = { 894c2420 ff15???????? eb0c 48630d???????? e8???????? }
            // n = 5, score = 100
            //   894c2420             | lea                 ecx, [0x1ca36]
            //   ff15????????         |                     
            //   eb0c                 | dec                 ebp
            //   48630d????????       |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1211392
}