rule win_romeos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.romeos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.romeos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5e 5d 5b 81c438200000 c20400 5f 5e }
            // n = 7, score = 400
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   81c438200000         | add                 esp, 0x2038
            //   c20400               | ret                 4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_1 = { 83c408 807c24480e 7406 43 83fb08 7cb6 e8???????? }
            // n = 7, score = 400
            //   83c408               | add                 esp, 8
            //   807c24480e           | cmp                 byte ptr [esp + 0x48], 0xe
            //   7406                 | je                  8
            //   43                   | inc                 ebx
            //   83fb08               | cmp                 ebx, 8
            //   7cb6                 | jl                  0xffffffb8
            //   e8????????           |                     

        $sequence_2 = { 85c0 0f85ef000000 85db 751d 807c244802 0f85e0000000 }
            // n = 6, score = 400
            //   85c0                 | test                eax, eax
            //   0f85ef000000         | jne                 0xf5
            //   85db                 | test                ebx, ebx
            //   751d                 | jne                 0x1f
            //   807c244802           | cmp                 byte ptr [esp + 0x48], 2
            //   0f85e0000000         | jne                 0xe6

        $sequence_3 = { 50 bd30000000 e8???????? 8bbc2454200000 }
            // n = 4, score = 400
            //   50                   | push                eax
            //   bd30000000           | mov                 ebp, 0x30
            //   e8????????           |                     
            //   8bbc2454200000       | mov                 edi, dword ptr [esp + 0x2054]

        $sequence_4 = { 83c408 807c24480e 7406 43 }
            // n = 4, score = 400
            //   83c408               | add                 esp, 8
            //   807c24480e           | cmp                 byte ptr [esp + 0x48], 0xe
            //   7406                 | je                  8
            //   43                   | inc                 ebx

        $sequence_5 = { 7406 43 83fb08 7cb6 e8???????? 99 }
            // n = 6, score = 400
            //   7406                 | je                  8
            //   43                   | inc                 ebx
            //   83fb08               | cmp                 ebx, 8
            //   7cb6                 | jl                  0xffffffb8
            //   e8????????           |                     
            //   99                   | cdq                 

        $sequence_6 = { 6a16 8d4c244c 6800200000 51 }
            // n = 4, score = 400
            //   6a16                 | push                0x16
            //   8d4c244c             | lea                 ecx, [esp + 0x4c]
            //   6800200000           | push                0x2000
            //   51                   | push                ecx

        $sequence_7 = { 81c438200000 c20400 5f 5e }
            // n = 4, score = 400
            //   81c438200000         | add                 esp, 0x2038
            //   c20400               | ret                 4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { 8bf1 57 b9ff070000 33c0 8d7c2449 c644244800 6a16 }
            // n = 7, score = 400
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   b9ff070000           | mov                 ecx, 0x7ff
            //   33c0                 | xor                 eax, eax
            //   8d7c2449             | lea                 edi, [esp + 0x49]
            //   c644244800           | mov                 byte ptr [esp + 0x48], 0
            //   6a16                 | push                0x16

        $sequence_9 = { 0f850d010000 33db 6a16 8d4c244c 6800200000 }
            // n = 5, score = 400
            //   0f850d010000         | jne                 0x113
            //   33db                 | xor                 ebx, ebx
            //   6a16                 | push                0x16
            //   8d4c244c             | lea                 ecx, [esp + 0x4c]
            //   6800200000           | push                0x2000

    condition:
        7 of them and filesize < 294912
}