rule win_rook_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rook."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rook"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffc3 4883c708 83fb22 72df 498bd6 488bcd ff15???????? }
            // n = 7, score = 100
            //   ffc3                 | dec                 esp
            //   4883c708             | mov                 dword ptr [esp + 0x2768], esp
            //   83fb22               | dec                 eax
            //   72df                 | mov                 dword ptr [esp + 0x30], edi
            //   498bd6               | dec                 ecx
            //   488bcd               | mov                 edx, esi
            //   ff15????????         |                     

        $sequence_1 = { 0f8521ffffff 44882b eb7b 488b9540070000 4c8d05979e0000 498bce }
            // n = 6, score = 100
            //   0f8521ffffff         | dec                 eax
            //   44882b               | lea                 ecx, [0xfffe2728]
            //   eb7b                 | dec                 eax
            //   488b9540070000       | arpl                bx, ax
            //   4c8d05979e0000       | mov                 edx, dword ptr [ecx + eax*4 + 0x1ea70]
            //   498bce               | dec                 eax

        $sequence_2 = { 33d2 ff15???????? 488b0d???????? 4d8bc7 33d2 ff15???????? 833d????????00 }
            // n = 7, score = 100
            //   33d2                 | add                 ebx, edx
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   4d8bc7               | mov                 byte ptr [esp + 0x20], al
            //   33d2                 | movzx               eax, byte ptr [ebp - 0x7e]
            //   ff15????????         |                     
            //   833d????????00       |                     

        $sequence_3 = { ff15???????? 488bce e8???????? 488d542440 488bcd ff15???????? 85c0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   488bce               | dec                 ecx
            //   e8????????           |                     
            //   488d542440           | add                 edx, 0x10
            //   488bcd               | dec                 eax
            //   ff15????????         |                     
            //   85c0                 | cmp                 edi, 0x3c

        $sequence_4 = { 4883ec38 488d05f5990000 41b91b000000 4889442420 e8???????? 4883c438 c3 }
            // n = 7, score = 100
            //   4883ec38             | dec                 eax
            //   488d05f5990000       | mov                 dword ptr [esp + 0x38], edi
            //   41b91b000000         | inc                 esp
            //   4889442420           | mov                 ecx, eax
            //   e8????????           |                     
            //   4883c438             | je                  0x2eb
            //   c3                   | dec                 eax

        $sequence_5 = { 498bd6 4d8d8115cc0400 4d03c4 0f1f4000 410fb64410ff 3cff 740b }
            // n = 7, score = 100
            //   498bd6               | mov                 edx, edi
            //   4d8d8115cc0400       | inc                 ebp
            //   4d03c4               | xor                 eax, eax
            //   0f1f4000             | dec                 esp
            //   410fb64410ff         | mov                 dword ptr [esp + 0x20], esp
            //   3cff                 | dec                 esp
            //   740b                 | mov                 dword ptr [esp + 0x8a8], edi

        $sequence_6 = { c605????????63 4c8d250099ffff b8ff000000 4d8d4901 }
            // n = 4, score = 100
            //   c605????????63       |                     
            //   4c8d250099ffff       | lea                 ecx, [esp + 0x6c]
            //   b8ff000000           | sub                 eax, 1
            //   4d8d4901             | dec                 eax

        $sequence_7 = { 498bcd 4c89bc2458270000 ff15???????? 488b0d???????? 4d8bc5 33d2 4c8be0 }
            // n = 7, score = 100
            //   498bcd               | dec                 ecx
            //   4c89bc2458270000     | add                 edi, 4
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   4d8bc5               | dec                 eax
            //   33d2                 | shr                 ecx, 8
            //   4c8be0               | inc                 esp

        $sequence_8 = { 8bd9 4c8d0dddce0000 b904000000 4c8d05c9ce0000 488d15b2bb0000 e8???????? }
            // n = 6, score = 100
            //   8bd9                 | dec                 eax
            //   4c8d0dddce0000       | add                 esp, 0x40
            //   b904000000           | dec                 eax
            //   4c8d05c9ce0000       | lea                 ecx, [0x55e02]
            //   488d15b2bb0000       | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 4863c8 4c8d4c2450 48894c2420 e8???????? 488d4c2450 ff15???????? }
            // n = 6, score = 100
            //   4863c8               | dec                 eax
            //   4c8d4c2450           | lea                 ecx, [0x1dcc9]
            //   48894c2420           | test                byte ptr [ecx + 0x38], 0x20
            //   e8????????           |                     
            //   488d4c2450           | je                  0xb0d
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 843776
}