rule win_roopirs_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.roopirs."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.roopirs"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ff15???????? 50 8d55d0 52 ff15???????? 8d4dc8 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d55d0               | lea                 edx, [ebp - 0x30]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d4dc8               | lea                 ecx, [ebp - 0x38]

        $sequence_1 = { 7433 c745fc3e000000 8b4dd8 51 68???????? }
            // n = 5, score = 100
            //   7433                 | je                  0x35
            //   c745fc3e000000       | mov                 dword ptr [ebp - 4], 0x3e
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]
            //   51                   | push                ecx
            //   68????????           |                     

        $sequence_2 = { ff15???????? 898544ffffff e9???????? c745fc07000000 8d5584 52 8b45dc }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   898544ffffff         | mov                 dword ptr [ebp - 0xbc], eax
            //   e9????????           |                     
            //   c745fc07000000       | mov                 dword ptr [ebp - 4], 7
            //   8d5584               | lea                 edx, [ebp - 0x7c]
            //   52                   | push                edx
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]

        $sequence_3 = { 8d45b8 50 ff15???????? 8bd0 8d4dd0 }
            // n = 5, score = 100
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4dd0               | lea                 ecx, [ebp - 0x30]

        $sequence_4 = { 51 8b5508 8b4234 8b4d08 8b5134 8b0a 50 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b4234               | mov                 eax, dword ptr [edx + 0x34]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b5134               | mov                 edx, dword ptr [ecx + 0x34]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   50                   | push                eax

        $sequence_5 = { 8d4dcc ff15???????? c745fc0d000000 6aff ff15???????? c745fc0e000000 }
            // n = 6, score = 100
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   ff15????????         |                     
            //   c745fc0d000000       | mov                 dword ptr [ebp - 4], 0xd
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   c745fc0e000000       | mov                 dword ptr [ebp - 4], 0xe

        $sequence_6 = { 8d4db8 ff15???????? 0fbf55b0 85d2 7433 c745fc2f000000 }
            // n = 6, score = 100
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   ff15????????         |                     
            //   0fbf55b0             | movsx               edx, word ptr [ebp - 0x50]
            //   85d2                 | test                edx, edx
            //   7433                 | je                  0x35
            //   c745fc2f000000       | mov                 dword ptr [ebp - 4], 0x2f

        $sequence_7 = { 52 8b45b0 50 ff15???????? 898570ffffff eb0a c78570ffffff00000000 }
            // n = 7, score = 100
            //   52                   | push                edx
            //   8b45b0               | mov                 eax, dword ptr [ebp - 0x50]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   898570ffffff         | mov                 dword ptr [ebp - 0x90], eax
            //   eb0a                 | jmp                 0xc
            //   c78570ffffff00000000     | mov    dword ptr [ebp - 0x90], 0

        $sequence_8 = { ff15???????? 8d4db8 ff15???????? c745fc16000000 8b55d8 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   ff15????????         |                     
            //   c745fc16000000       | mov                 dword ptr [ebp - 4], 0x16
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]

        $sequence_9 = { 8b550c 8d4dd8 ff15???????? c745fc02000000 6a01 8b45d8 50 }
            // n = 7, score = 100
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   ff15????????         |                     
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   6a01                 | push                1
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 344064
}