rule win_roopy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.roopy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.roopy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45c0 30c9 ba38000000 e8???????? c745c0504b0606 8d45a8 }
            // n = 6, score = 300
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   30c9                 | xor                 cl, cl
            //   ba38000000           | mov                 edx, 0x38
            //   e8????????           |                     
            //   c745c0504b0606       | mov                 dword ptr [ebp - 0x40], 0x6064b50
            //   8d45a8               | lea                 eax, [ebp - 0x58]

        $sequence_1 = { 8b45f8 c7401400000000 8b45f8 e8???????? c745f401000000 }
            // n = 5, score = 300
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   c7401400000000       | mov                 dword ptr [eax + 0x14], 0
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   e8????????           |                     
            //   c745f401000000       | mov                 dword ptr [ebp - 0xc], 1

        $sequence_2 = { 6631d2 8d85d8feffff e8???????? 8d45dc 30c9 6631d2 }
            // n = 6, score = 300
            //   6631d2               | xor                 dx, dx
            //   8d85d8feffff         | lea                 eax, [ebp - 0x128]
            //   e8????????           |                     
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   30c9                 | xor                 cl, cl
            //   6631d2               | xor                 dx, dx

        $sequence_3 = { 8b09 ff5164 8345f401 8b45f8 8b4004 e8???????? }
            // n = 6, score = 300
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   ff5164               | call                dword ptr [ecx + 0x64]
            //   8345f401             | add                 dword ptr [ebp - 0xc], 1
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   e8????????           |                     

        $sequence_4 = { c78580fdffff00000000 c78584fdffff00000000 c7858cfeffff00000000 31c0 }
            // n = 4, score = 300
            //   c78580fdffff00000000     | mov    dword ptr [ebp - 0x280], 0
            //   c78584fdffff00000000     | mov    dword ptr [ebp - 0x27c], 0
            //   c7858cfeffff00000000     | mov    dword ptr [ebp - 0x174], 0
            //   31c0                 | xor                 eax, eax

        $sequence_5 = { 6631c9 ba03010000 e8???????? 8b85b8feffff ba???????? }
            // n = 5, score = 300
            //   6631c9               | xor                 cx, cx
            //   ba03010000           | mov                 edx, 0x103
            //   e8????????           |                     
            //   8b85b8feffff         | mov                 eax, dword ptr [ebp - 0x148]
            //   ba????????           |                     

        $sequence_6 = { c7406000000000 8b45f4 c7406400000000 8b45f4 83785c00 770b 7210 }
            // n = 7, score = 300
            //   c7406000000000       | mov                 dword ptr [eax + 0x60], 0
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   c7406400000000       | mov                 dword ptr [eax + 0x64], 0
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83785c00             | cmp                 dword ptr [eax + 0x5c], 0
            //   770b                 | ja                  0xd
            //   7210                 | jb                  0x12

        $sequence_7 = { 30c9 6631d2 e8???????? 0fb745fc 68ff000000 8d8dd8feffff baffffffff }
            // n = 7, score = 300
            //   30c9                 | xor                 cl, cl
            //   6631d2               | xor                 dx, dx
            //   e8????????           |                     
            //   0fb745fc             | movzx               eax, word ptr [ebp - 4]
            //   68ff000000           | push                0xff
            //   8d8dd8feffff         | lea                 ecx, [ebp - 0x128]
            //   baffffffff           | mov                 edx, 0xffffffff

        $sequence_8 = { d805???????? d80d???????? 895df0 897df4 0fba65f41f df6df0 7306 }
            // n = 7, score = 300
            //   d805????????         |                     
            //   d80d????????         |                     
            //   895df0               | mov                 dword ptr [ebp - 0x10], ebx
            //   897df4               | mov                 dword ptr [ebp - 0xc], edi
            //   0fba65f41f           | bt                  dword ptr [ebp - 0xc], 0x1f
            //   df6df0               | fild                qword ptr [ebp - 0x10]
            //   7306                 | jae                 8

        $sequence_9 = { 8b52fc 29c2 8d4a01 8d5001 8b45fc e8???????? 89d8 }
            // n = 7, score = 300
            //   8b52fc               | mov                 edx, dword ptr [edx - 4]
            //   29c2                 | sub                 edx, eax
            //   8d4a01               | lea                 ecx, [edx + 1]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   89d8                 | mov                 eax, ebx

    condition:
        7 of them and filesize < 739328
}