rule win_roseam_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.roseam."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.roseam"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5d c3 8d4db8 c60200 51 }
            // n = 5, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   c60200               | mov                 byte ptr [edx], 0
            //   51                   | push                ecx

        $sequence_1 = { 33c9 66894304 66894b06 50 68???????? }
            // n = 5, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   66894304             | mov                 word ptr [ebx + 4], ax
            //   66894b06             | mov                 word ptr [ebx + 6], cx
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_2 = { 0f8682000000 66833b20 747c 56 }
            // n = 4, score = 100
            //   0f8682000000         | jbe                 0x88
            //   66833b20             | cmp                 word ptr [ebx], 0x20
            //   747c                 | je                  0x7e
            //   56                   | push                esi

        $sequence_3 = { 9d 5d 8b45f8 85c0 0f84db000000 }
            // n = 5, score = 100
            //   9d                   | popfd               
            //   5d                   | pop                 ebp
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   85c0                 | test                eax, eax
            //   0f84db000000         | je                  0xe1

        $sequence_4 = { 41 40 894dfc 8945f8 68???????? 50 9c }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   40                   | inc                 eax
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   68????????           |                     
            //   50                   | push                eax
            //   9c                   | pushfd              

        $sequence_5 = { 58 58 8b45bc 48 7409 83e803 0f854c010000 }
            // n = 7, score = 100
            //   58                   | pop                 eax
            //   58                   | pop                 eax
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]
            //   48                   | dec                 eax
            //   7409                 | je                  0xb
            //   83e803               | sub                 eax, 3
            //   0f854c010000         | jne                 0x152

        $sequence_6 = { 8d85f4fcffff 8a10 8a1e 8aca 3ad3 751e 84c9 }
            // n = 7, score = 100
            //   8d85f4fcffff         | lea                 eax, [ebp - 0x30c]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   8a1e                 | mov                 bl, byte ptr [esi]
            //   8aca                 | mov                 cl, dl
            //   3ad3                 | cmp                 dl, bl
            //   751e                 | jne                 0x20
            //   84c9                 | test                cl, cl

        $sequence_7 = { 803a2e 740c 8a4201 42 }
            // n = 4, score = 100
            //   803a2e               | cmp                 byte ptr [edx], 0x2e
            //   740c                 | je                  0xe
            //   8a4201               | mov                 al, byte ptr [edx + 1]
            //   42                   | inc                 edx

        $sequence_8 = { c7451800000000 84c0 7478 68???????? 50 }
            // n = 5, score = 100
            //   c7451800000000       | mov                 dword ptr [ebp + 0x18], 0
            //   84c0                 | test                al, al
            //   7478                 | je                  0x7a
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_9 = { b9ff000000 33c0 8dbdf1f7ffff 8895f0f7ffff 8b1e f3ab }
            // n = 6, score = 100
            //   b9ff000000           | mov                 ecx, 0xff
            //   33c0                 | xor                 eax, eax
            //   8dbdf1f7ffff         | lea                 edi, [ebp - 0x80f]
            //   8895f0f7ffff         | mov                 byte ptr [ebp - 0x810], dl
            //   8b1e                 | mov                 ebx, dword ptr [esi]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 221184
}