rule win_rover_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rover."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rover"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7478 8b4c2474 8d442434 50 68ff3f0000 8d83f4050000 50 }
            // n = 7, score = 100
            //   7478                 | je                  0x7a
            //   8b4c2474             | mov                 ecx, dword ptr [esp + 0x74]
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   50                   | push                eax
            //   68ff3f0000           | push                0x3fff
            //   8d83f4050000         | lea                 eax, [ebx + 0x5f4]
            //   50                   | push                eax

        $sequence_1 = { eb03 83c604 56 ff15???????? 33c9 83c404 84c0 }
            // n = 7, score = 100
            //   eb03                 | jmp                 5
            //   83c604               | add                 esi, 4
            //   56                   | push                esi
            //   ff15????????         |                     
            //   33c9                 | xor                 ecx, ecx
            //   83c404               | add                 esp, 4
            //   84c0                 | test                al, al

        $sequence_2 = { 8b0d???????? 50 51 6a02 6a1c 8d9424dc000000 52 }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6a02                 | push                2
            //   6a1c                 | push                0x1c
            //   8d9424dc000000       | lea                 edx, [esp + 0xdc]
            //   52                   | push                edx

        $sequence_3 = { 8b5b10 8b44241c 8d4bfc 3bc1 745c 8928 83c004 }
            // n = 7, score = 100
            //   8b5b10               | mov                 ebx, dword ptr [ebx + 0x10]
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8d4bfc               | lea                 ecx, [ebx - 4]
            //   3bc1                 | cmp                 eax, ecx
            //   745c                 | je                  0x5e
            //   8928                 | mov                 dword ptr [eax], ebp
            //   83c004               | add                 eax, 4

        $sequence_4 = { eb6a 80bc241d01000000 7409 51 ff15???????? eb57 80bc241e01000000 }
            // n = 7, score = 100
            //   eb6a                 | jmp                 0x6c
            //   80bc241d01000000     | cmp                 byte ptr [esp + 0x11d], 0
            //   7409                 | je                  0xb
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   eb57                 | jmp                 0x59
            //   80bc241e01000000     | cmp                 byte ptr [esp + 0x11e], 0

        $sequence_5 = { 85c0 740c 8b0d???????? 8b5140 50 ffd2 8d442428 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe
            //   8b0d????????         |                     
            //   8b5140               | mov                 edx, dword ptr [ecx + 0x40]
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   8d442428             | lea                 eax, [esp + 0x28]

        $sequence_6 = { 83beb000000000 0f846d030000 83bb5802000000 742c 83bb4087000000 7523 8b8e94000000 }
            // n = 7, score = 100
            //   83beb000000000       | cmp                 dword ptr [esi + 0xb0], 0
            //   0f846d030000         | je                  0x373
            //   83bb5802000000       | cmp                 dword ptr [ebx + 0x258], 0
            //   742c                 | je                  0x2e
            //   83bb4087000000       | cmp                 dword ptr [ebx + 0x8740], 0
            //   7523                 | jne                 0x25
            //   8b8e94000000         | mov                 ecx, dword ptr [esi + 0x94]

        $sequence_7 = { 33ff 837d3805 89442410 894c2414 897c240c 750e 8bc6 }
            // n = 7, score = 100
            //   33ff                 | xor                 edi, edi
            //   837d3805             | cmp                 dword ptr [ebp + 0x38], 5
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   897c240c             | mov                 dword ptr [esp + 0xc], edi
            //   750e                 | jne                 0x10
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 897c2424 83ffff 0f84e8060000 8b2d???????? }
            // n = 4, score = 100
            //   897c2424             | mov                 dword ptr [esp + 0x24], edi
            //   83ffff               | cmp                 edi, -1
            //   0f84e8060000         | je                  0x6ee
            //   8b2d????????         |                     

        $sequence_9 = { ff25???????? 8d8d48ffffff ff25???????? 8b542408 8d8230ffffff 8b8a2cffffff 33c8 }
            // n = 7, score = 100
            //   ff25????????         |                     
            //   8d8d48ffffff         | lea                 ecx, [ebp - 0xb8]
            //   ff25????????         |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d8230ffffff         | lea                 eax, [edx - 0xd0]
            //   8b8a2cffffff         | mov                 ecx, dword ptr [edx - 0xd4]
            //   33c8                 | xor                 ecx, eax

    condition:
        7 of them and filesize < 704512
}