rule win_royalcli_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.royalcli."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.royalcli"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a02 53 56 c745e844006900 c745ec73006100 c745f062006c00 c745f465004300 }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   56                   | push                esi
            //   c745e844006900       | mov                 dword ptr [ebp - 0x18], 0x690044
            //   c745ec73006100       | mov                 dword ptr [ebp - 0x14], 0x610073
            //   c745f062006c00       | mov                 dword ptr [ebp - 0x10], 0x6c0062
            //   c745f465004300       | mov                 dword ptr [ebp - 0xc], 0x430065

        $sequence_1 = { 33f6 85ff 7e4b 4f c1ef02 8d4a01 }
            // n = 6, score = 100
            //   33f6                 | xor                 esi, esi
            //   85ff                 | test                edi, edi
            //   7e4b                 | jle                 0x4d
            //   4f                   | dec                 edi
            //   c1ef02               | shr                 edi, 2
            //   8d4a01               | lea                 ecx, [edx + 1]

        $sequence_2 = { 66895008 6800000080 8d85d8fdffff 50 ffd3 83f8ff 7421 }
            // n = 7, score = 100
            //   66895008             | mov                 word ptr [eax + 8], dx
            //   6800000080           | push                0x80000000
            //   8d85d8fdffff         | lea                 eax, [ebp - 0x228]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   83f8ff               | cmp                 eax, -1
            //   7421                 | je                  0x23

        $sequence_3 = { 6840000100 89b5c0feffff e8???????? 83c404 }
            // n = 4, score = 100
            //   6840000100           | push                0x10040
            //   89b5c0feffff         | mov                 dword ptr [ebp - 0x140], esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_4 = { 5d c3 56 57 6a01 50 e8???????? }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a01                 | push                1
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 33cd e8???????? 8be5 5d c3 8b85e8fcffff 6840771b00 }
            // n = 7, score = 100
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b85e8fcffff         | mov                 eax, dword ptr [ebp - 0x318]
            //   6840771b00           | push                0x1b7740

        $sequence_6 = { 68???????? ffd7 8d55e8 52 e8???????? 83c404 8bd8 }
            // n = 7, score = 100
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   8d55e8               | lea                 edx, [ebp - 0x18]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8bd8                 | mov                 ebx, eax

        $sequence_7 = { 8b5d0c 8995bcf9ffff 8b5518 899da8f9ffff 8995b8f9ffff 7d11 33c0 }
            // n = 7, score = 100
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   8995bcf9ffff         | mov                 dword ptr [ebp - 0x644], edx
            //   8b5518               | mov                 edx, dword ptr [ebp + 0x18]
            //   899da8f9ffff         | mov                 dword ptr [ebp - 0x658], ebx
            //   8995b8f9ffff         | mov                 dword ptr [ebp - 0x648], edx
            //   7d11                 | jge                 0x13
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 8b85bcfeffff 50 33f6 ff15???????? e9???????? 3d00000100 0f8f2bffffff }
            // n = 7, score = 100
            //   8b85bcfeffff         | mov                 eax, dword ptr [ebp - 0x144]
            //   50                   | push                eax
            //   33f6                 | xor                 esi, esi
            //   ff15????????         |                     
            //   e9????????           |                     
            //   3d00000100           | cmp                 eax, 0x10000
            //   0f8f2bffffff         | jg                  0xffffff31

        $sequence_9 = { 8d85c4fdffff 50 68???????? 68???????? 68???????? ffd6 bf???????? }
            // n = 7, score = 100
            //   8d85c4fdffff         | lea                 eax, [ebp - 0x23c]
            //   50                   | push                eax
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   bf????????           |                     

    condition:
        7 of them and filesize < 204800
}