rule win_rtm_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rtm_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rtm_locker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd7 8b44241c 8d542410 52 8d542424 c744241400000000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   52                   | push                edx
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   c744241400000000     | mov                 dword ptr [esp + 0x14], 0

        $sequence_1 = { 8bbd38ffffff 33d0 c1c210 03ca 33f1 c1c60c }
            // n = 6, score = 100
            //   8bbd38ffffff         | mov                 edi, dword ptr [ebp - 0xc8]
            //   33d0                 | xor                 edx, eax
            //   c1c210               | rol                 edx, 0x10
            //   03ca                 | add                 ecx, edx
            //   33f1                 | xor                 esi, ecx
            //   c1c60c               | rol                 esi, 0xc

        $sequence_2 = { 0f29a424b0000000 660fd4c1 0f28e2 0f29b42410010000 660f62e0 660f6ad0 }
            // n = 6, score = 100
            //   0f29a424b0000000     | movaps              xmmword ptr [esp + 0xb0], xmm4
            //   660fd4c1             | paddq               xmm0, xmm1
            //   0f28e2               | movaps              xmm4, xmm2
            //   0f29b42410010000     | movaps              xmmword ptr [esp + 0x110], xmm6
            //   660f62e0             | punpckldq           xmm4, xmm0
            //   660f6ad0             | punpckhdq           xmm2, xmm0

        $sequence_3 = { 8d85e8feffff 50 6a00 ff15???????? 85c0 7440 68???????? }
            // n = 7, score = 100
            //   8d85e8feffff         | lea                 eax, [ebp - 0x118]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7440                 | je                  0x42
            //   68????????           |                     

        $sequence_4 = { 8d8550fcffff 50 8d95c8feffff 8d8d68ffffff e8???????? 83c404 8d8d68ffffff }
            // n = 7, score = 100
            //   8d8550fcffff         | lea                 eax, [ebp - 0x3b0]
            //   50                   | push                eax
            //   8d95c8feffff         | lea                 edx, [ebp - 0x138]
            //   8d8d68ffffff         | lea                 ecx, [ebp - 0x98]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d8d68ffffff         | lea                 ecx, [ebp - 0x98]

        $sequence_5 = { 0f1195ecfdffff 0f119dfcfdffff 0f11a50cfeffff 0f11851cfeffff 660f1f440000 8b840d2cfeffff 01840d64fcffff }
            // n = 7, score = 100
            //   0f1195ecfdffff       | movups              xmmword ptr [ebp - 0x214], xmm2
            //   0f119dfcfdffff       | movups              xmmword ptr [ebp - 0x204], xmm3
            //   0f11a50cfeffff       | movups              xmmword ptr [ebp - 0x1f4], xmm4
            //   0f11851cfeffff       | movups              xmmword ptr [ebp - 0x1e4], xmm0
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   8b840d2cfeffff       | mov                 eax, dword ptr [ebp + ecx - 0x1d4]
            //   01840d64fcffff       | add                 dword ptr [ebp + ecx - 0x39c], eax

        $sequence_6 = { 57 660f1f440000 3a1a 7403 42 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   3a1a                 | cmp                 bl, byte ptr [edx]
            //   7403                 | je                  5
            //   42                   | inc                 edx

        $sequence_7 = { 0f108560feffff 0f118570fdffff 0f108570feffff 0f118580fdffff e8???????? 8d8d30feffff e8???????? }
            // n = 7, score = 100
            //   0f108560feffff       | movups              xmm0, xmmword ptr [ebp - 0x1a0]
            //   0f118570fdffff       | movups              xmmword ptr [ebp - 0x290], xmm0
            //   0f108570feffff       | movups              xmm0, xmmword ptr [ebp - 0x190]
            //   0f118580fdffff       | movups              xmmword ptr [ebp - 0x280], xmm0
            //   e8????????           |                     
            //   8d8d30feffff         | lea                 ecx, [ebp - 0x1d0]
            //   e8????????           |                     

        $sequence_8 = { 894590 33fe c1c708 8d040f 8945ec 33c2 }
            // n = 6, score = 100
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   33fe                 | xor                 edi, esi
            //   c1c708               | rol                 edi, 8
            //   8d040f               | lea                 eax, [edi + ecx]
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax
            //   33c2                 | xor                 eax, edx

        $sequence_9 = { 8b4dec 48 897dfc 897db8 894508 85c0 0f8f3ffeffff }
            // n = 7, score = 100
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   48                   | dec                 eax
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   897db8               | mov                 dword ptr [ebp - 0x48], edi
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   85c0                 | test                eax, eax
            //   0f8f3ffeffff         | jg                  0xfffffe45

    condition:
        7 of them and filesize < 598016
}