rule win_rtpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rtpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rtpos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 8b55d4 52 ff15???????? 8b45cc 50 ff15???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 8d8dd8fcffff 51 e8???????? 83c40c c785c4fcffff00000000 }
            // n = 5, score = 100
            //   8d8dd8fcffff         | lea                 ecx, [ebp - 0x328]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c785c4fcffff00000000     | mov    dword ptr [ebp - 0x33c], 0

        $sequence_2 = { 50 ff15???????? 8b4dcc 51 ff15???????? e9???????? 8b55ec }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4dcc               | mov                 ecx, dword ptr [ebp - 0x34]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_3 = { 8945b4 837db4ff 0f84d8010000 33c0 8945e8 8945ec }
            // n = 6, score = 100
            //   8945b4               | mov                 dword ptr [ebp - 0x4c], eax
            //   837db4ff             | cmp                 dword ptr [ebp - 0x4c], -1
            //   0f84d8010000         | je                  0x1de
            //   33c0                 | xor                 eax, eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_4 = { 0f84bc9f0000 ff7508 48 a3???????? }
            // n = 4, score = 100
            //   0f84bc9f0000         | je                  0x9fc2
            //   ff7508               | push                dword ptr [ebp + 8]
            //   48                   | dec                 eax
            //   a3????????           |                     

        $sequence_5 = { 85c0 751b 8b4dd4 51 ff15???????? }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   751b                 | jne                 0x1d
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_6 = { 6bf830 894df8 6a0a 8b048db86a4300 5b 8b543818 8955ec }
            // n = 7, score = 100
            //   6bf830               | imul                edi, eax, 0x30
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   6a0a                 | push                0xa
            //   8b048db86a4300       | mov                 eax, dword ptr [ecx*4 + 0x436ab8]
            //   5b                   | pop                 ebx
            //   8b543818             | mov                 edx, dword ptr [eax + edi + 0x18]
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx

        $sequence_7 = { 8b048db86a4300 f644382848 58 743a 668b55fc 663bd0 7505 }
            // n = 7, score = 100
            //   8b048db86a4300       | mov                 eax, dword ptr [ecx*4 + 0x436ab8]
            //   f644382848           | test                byte ptr [eax + edi + 0x28], 0x48
            //   58                   | pop                 eax
            //   743a                 | je                  0x3c
            //   668b55fc             | mov                 dx, word ptr [ebp - 4]
            //   663bd0               | cmp                 dx, ax
            //   7505                 | jne                 7

        $sequence_8 = { c745d800000000 837ddc00 7411 8b4ddc 51 }
            // n = 5, score = 100
            //   c745d800000000       | mov                 dword ptr [ebp - 0x28], 0
            //   837ddc00             | cmp                 dword ptr [ebp - 0x24], 0
            //   7411                 | je                  0x13
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   51                   | push                ecx

        $sequence_9 = { 6a02 8d4dfc e8???????? 8b4d08 c7410801000000 8b5108 8b049524604300 }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   e8????????           |                     
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   c7410801000000       | mov                 dword ptr [ecx + 8], 1
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   8b049524604300       | mov                 eax, dword ptr [edx*4 + 0x436024]

    condition:
        7 of them and filesize < 507904
}