rule win_rustock_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rustock."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rustock"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8945c0 85c0 7504 33f6 eb21 ff751c }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   85c0                 | test                eax, eax
            //   7504                 | jne                 6
            //   33f6                 | xor                 esi, esi
            //   eb21                 | jmp                 0x23
            //   ff751c               | push                dword ptr [ebp + 0x1c]

        $sequence_1 = { f7d1 8b15???????? 8d6424fc 893424 5a 31c6 }
            // n = 6, score = 100
            //   f7d1                 | not                 ecx
            //   8b15????????         |                     
            //   8d6424fc             | lea                 esp, [esp - 4]
            //   893424               | mov                 dword ptr [esp], esi
            //   5a                   | pop                 edx
            //   31c6                 | xor                 esi, eax

        $sequence_2 = { 7403 46 ebd4 0fb60e 46 83f92d 8bd1 }
            // n = 7, score = 100
            //   7403                 | je                  5
            //   46                   | inc                 esi
            //   ebd4                 | jmp                 0xffffffd6
            //   0fb60e               | movzx               ecx, byte ptr [esi]
            //   46                   | inc                 esi
            //   83f92d               | cmp                 ecx, 0x2d
            //   8bd1                 | mov                 edx, ecx

        $sequence_3 = { 29f8 83cbff f7d3 b8670e0100 8d0dc8680100 01d0 }
            // n = 6, score = 100
            //   29f8                 | sub                 eax, edi
            //   83cbff               | or                  ebx, 0xffffffff
            //   f7d3                 | not                 ebx
            //   b8670e0100           | mov                 eax, 0x10e67
            //   8d0dc8680100         | lea                 ecx, [0x168c8]
            //   01d0                 | add                 eax, edx

        $sequence_4 = { 53 ffd6 68ad020000 53 a3???????? ffd6 689d020000 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   68ad020000           | push                0x2ad
            //   53                   | push                ebx
            //   a3????????           |                     
            //   ffd6                 | call                esi
            //   689d020000           | push                0x29d

        $sequence_5 = { df7809 60 9f 79c1 7cc2 }
            // n = 5, score = 100
            //   df7809               | fistp               qword ptr [eax + 9]
            //   60                   | pushal              
            //   9f                   | lahf                
            //   79c1                 | jns                 0xffffffc3
            //   7cc2                 | jl                  0xffffffc4

        $sequence_6 = { 68d44f0100 59 0315???????? 21fb 031d???????? 31f1 83f2ff }
            // n = 7, score = 100
            //   68d44f0100           | push                0x14fd4
            //   59                   | pop                 ecx
            //   0315????????         |                     
            //   21fb                 | and                 ebx, edi
            //   031d????????         |                     
            //   31f1                 | xor                 ecx, esi
            //   83f2ff               | xor                 edx, 0xffffffff

        $sequence_7 = { 57 68e1030000 ff550c 68d1030000 }
            // n = 4, score = 100
            //   57                   | push                edi
            //   68e1030000           | push                0x3e1
            //   ff550c               | call                dword ptr [ebp + 0xc]
            //   68d1030000           | push                0x3d1

        $sequence_8 = { 8bc7 e9???????? 897dcc 33db 897dc8 397d08 7508 }
            // n = 7, score = 100
            //   8bc7                 | mov                 eax, edi
            //   e9????????           |                     
            //   897dcc               | mov                 dword ptr [ebp - 0x34], edi
            //   33db                 | xor                 ebx, ebx
            //   897dc8               | mov                 dword ptr [ebp - 0x38], edi
            //   397d08               | cmp                 dword ptr [ebp + 8], edi
            //   7508                 | jne                 0xa

        $sequence_9 = { 8d04bd04000000 50 e8???????? 8bd8 }
            // n = 4, score = 100
            //   8d04bd04000000       | lea                 eax, [edi*4 + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax

    condition:
        7 of them and filesize < 565248
}