rule win_rustonotto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rustonotto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rustonotto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4889fa 84c0 0f84befdffff 488b0d???????? 488b4138 4885c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889fa               | dec                 eax
            //   84c0                 | mov                 eax, dword ptr [ecx + 0x38]
            //   0f84befdffff         | dec                 eax
            //   488b0d????????       |                     
            //   488b4138             | test                eax, eax
            //   4885c0               | dec                 eax

        $sequence_1 = { e8???????? 4983c4f9 488d8528010000 0f1f4000 4c8b30 450fb7aed2030000 498d742401 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4983c4f9             | mov                 eax, 0xf0
            //   488d8528010000       | dec                 eax
            //   0f1f4000             | lea                 ecx, [ebp + 0x1288]
            //   4c8b30               | dec                 eax
            //   450fb7aed2030000     | lea                 edx, [ebp + 0x590]
            //   498d742401           | inc                 ecx

        $sequence_2 = { eb02 31c0 66897d08 6689750a 488945f8 488d05a4751800 48894500 }
            // n = 7, score = 100
            //   eb02                 | mov                 ebx, dword ptr [edx]
            //   31c0                 | dec                 eax
            //   66897d08             | test                ebx, ebx
            //   6689750a             | mov                 byte ptr [esi], 0
            //   488945f8             | dec                 eax
            //   488d05a4751800       | lea                 eax, [0x101002]
            //   48894500             | dec                 eax

        $sequence_3 = { eb0f b908000000 ba18000000 e8???????? 0f0b 90 4889542410 }
            // n = 7, score = 100
            //   eb0f                 | mov                 dword ptr [ebp + 0x60], ecx
            //   b908000000           | inc                 esp
            //   ba18000000           | mov                 byte ptr [ebp + 0x11e], bh
            //   e8????????           |                     
            //   0f0b                 | inc                 esp
            //   90                   | mov                 byte ptr [ebp + 8], bh
            //   4889542410           | jmp                 0x144

        $sequence_4 = { 84c0 0f85d8feffff c6470101 e9???????? c685c700000000 e8???????? 84c0 }
            // n = 7, score = 100
            //   84c0                 | mov                 eax, dword ptr [ecx + 0x38]
            //   0f85d8feffff         | dec                 eax
            //   c6470101             | test                eax, eax
            //   e9????????           |                     
            //   c685c700000000       | je                  0x2be
            //   e8????????           |                     
            //   84c0                 | dec                 eax

        $sequence_5 = { 740f 488d4d60 488b5550 4c8b4558 ff5020 90 4883c430 }
            // n = 7, score = 100
            //   740f                 | mov                 byte ptr [ebp + 0x3e], 1
            //   488d4d60             | call                eax
            //   488b5550             | dec                 eax
            //   4c8b4558             | mov                 eax, dword ptr [ebp]
            //   ff5020               | dec                 eax
            //   90                   | mov                 dword ptr [ebp + 0x30], eax
            //   4883c430             | je                  0x3be

        $sequence_6 = { e8???????? 0fb64520 3c03 751f 4183bf1801000001 0f858d000000 66c7060305 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb64520             | cmp                 eax, 4
            //   3c03                 | setb                al
            //   751f                 | or                  al, cl
            //   4183bf1801000001     | je                  0x367
            //   0f858d000000         | dec                 ebp
            //   66c7060305           | mov                 edi, dword ptr [esp]

        $sequence_7 = { e8???????? 8b8580040000 83f802 7432 83f803 0f84ba1d0000 a801 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b8580040000         | movups              xmm0, xmmword ptr [ebp + 0x18]
            //   83f802               | test                bl, bl
            //   7432                 | je                  0x4fb
            //   83f803               | cmp                 dword ptr [ebp + 0x3d8], 1
            //   0f84ba1d0000         | jne                 0x4fb
            //   a801                 | mov                 ecx, 4

        $sequence_8 = { 747b 8b514c 448b8990000000 4101d1 b801000000 7058 0f88f4010000 }
            // n = 7, score = 100
            //   747b                 | lea                 ecx, [0x113a79]
            //   8b514c               | dec                 eax
            //   448b8990000000       | arpl                word ptr [ecx + eax*4], ax
            //   4101d1               | je                  0x2a4
            //   b801000000           | dec                 eax
            //   7058                 | mov                 esi, dword ptr [ebp + 0x38]
            //   0f88f4010000         | dec                 eax

        $sequence_9 = { c6858f04000001 c6858e04000000 8b8578040000 88858d040000 c6858c04000001 c6858b04000001 488d0d2f2a1000 }
            // n = 7, score = 100
            //   c6858f04000001       | mov                 byte ptr [ebp + 0x485], 1
            //   c6858e04000000       | mov                 byte ptr [ebp + 0x484], 1
            //   8b8578040000         | test                al, al
            //   88858d040000         | je                  0x105a
            //   c6858c04000001       | dec                 eax
            //   c6858b04000001       | mov                 eax, dword ptr [ecx + 0x38]
            //   488d0d2f2a1000       | mov                 byte ptr [ebp + 0x86], 0

    condition:
        7 of them and filesize < 5989376
}