rule win_rusty_claw_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.rusty_claw."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rusty_claw"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 56 83ec08 8b5c241c 8b7c2418 89e0 8d742404 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   56                   | push                esi
            //   83ec08               | sub                 esp, 8
            //   8b5c241c             | mov                 ebx, dword ptr [esp + 0x1c]
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   89e0                 | mov                 eax, esp
            //   8d742404             | lea                 esi, [esp + 4]

        $sequence_1 = { 5b 5d c3 8b4e10 ba???????? 6a04 e8???????? }
            // n = 7, score = 100
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   ba????????           |                     
            //   6a04                 | push                4
            //   e8????????           |                     

        $sequence_2 = { 037904 034108 89d1 c1c60d c1ea0a c1c10f 31ce }
            // n = 7, score = 100
            //   037904               | add                 edi, dword ptr [ecx + 4]
            //   034108               | add                 eax, dword ptr [ecx + 8]
            //   89d1                 | mov                 ecx, edx
            //   c1c60d               | rol                 esi, 0xd
            //   c1ea0a               | shr                 edx, 0xa
            //   c1c10f               | rol                 ecx, 0xf
            //   31ce                 | xor                 esi, ecx

        $sequence_3 = { 8b5664 e8???????? b001 8b8eb0050000 64890d00000000 8d65f4 5e }
            // n = 7, score = 100
            //   8b5664               | mov                 edx, dword ptr [esi + 0x64]
            //   e8????????           |                     
            //   b001                 | mov                 al, 1
            //   8b8eb0050000         | mov                 ecx, dword ptr [esi + 0x5b0]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   8d65f4               | lea                 esp, [ebp - 0xc]
            //   5e                   | pop                 esi

        $sequence_4 = { 29c2 29ca 85d2 7409 4a 803ec0 8d76ff }
            // n = 7, score = 100
            //   29c2                 | sub                 edx, eax
            //   29ca                 | sub                 edx, ecx
            //   85d2                 | test                edx, edx
            //   7409                 | je                  0xb
            //   4a                   | dec                 edx
            //   803ec0               | cmp                 byte ptr [esi], 0xc0
            //   8d76ff               | lea                 esi, [esi - 1]

        $sequence_5 = { 0fb7c2 01c8 c3 89d0 354718c32c c1c002 31d0 }
            // n = 7, score = 100
            //   0fb7c2               | movzx               eax, dx
            //   01c8                 | add                 eax, ecx
            //   c3                   | ret                 
            //   89d0                 | mov                 eax, edx
            //   354718c32c           | xor                 eax, 0x2cc31847
            //   c1c002               | rol                 eax, 2
            //   31d0                 | xor                 eax, edx

        $sequence_6 = { 8dbe850ab727 8974245c 89442408 8d81fc6d2c4d 8b4c2458 89442450 8b442430 }
            // n = 7, score = 100
            //   8dbe850ab727         | lea                 edi, [esi + 0x27b70a85]
            //   8974245c             | mov                 dword ptr [esp + 0x5c], esi
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8d81fc6d2c4d         | lea                 eax, [ecx + 0x4d2c6dfc]
            //   8b4c2458             | mov                 ecx, dword ptr [esp + 0x58]
            //   89442450             | mov                 dword ptr [esp + 0x50], eax
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]

        $sequence_7 = { 6a0a 5a f7e2 89c3 0f90c2 01cb 0f92c0 }
            // n = 7, score = 100
            //   6a0a                 | push                0xa
            //   5a                   | pop                 edx
            //   f7e2                 | mul                 edx
            //   89c3                 | mov                 ebx, eax
            //   0f90c2               | seto                dl
            //   01cb                 | add                 ebx, ecx
            //   0f92c0               | setb                al

        $sequence_8 = { 8b6c241c 8974240c 89de 894c2444 89542438 89442420 894c2424 }
            // n = 7, score = 100
            //   8b6c241c             | mov                 ebp, dword ptr [esp + 0x1c]
            //   8974240c             | mov                 dword ptr [esp + 0xc], esi
            //   89de                 | mov                 esi, ebx
            //   894c2444             | mov                 dword ptr [esp + 0x44], ecx
            //   89542438             | mov                 dword ptr [esp + 0x38], edx
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   894c2424             | mov                 dword ptr [esp + 0x24], ecx

        $sequence_9 = { 8d043b 99 2bc2 8bf0 d1fe 6a55 ff34f5b8444300 }
            // n = 7, score = 100
            //   8d043b               | lea                 eax, [ebx + edi]
            //   99                   | cdq                 
            //   2bc2                 | sub                 eax, edx
            //   8bf0                 | mov                 esi, eax
            //   d1fe                 | sar                 esi, 1
            //   6a55                 | push                0x55
            //   ff34f5b8444300       | push                dword ptr [esi*8 + 0x4344b8]

    condition:
        7 of them and filesize < 518144
}