rule win_ryuk_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ryuk."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ryuk"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 6a01 6a00 6814010000 }
            // n = 4, score = 2400
            //   68????????           |                     
            //   6a01                 | cmp                 word ptr [edi + 2], 0x54
            //   6a00                 | jne                 0x18
            //   6814010000           | cmp                 word ptr [edi], 0x4e

        $sequence_1 = { ff15???????? 85c0 7508 6a01 ff15???????? 68???????? 6a01 }
            // n = 7, score = 2300
            //   ff15????????         |                     
            //   85c0                 | jne                 0x18
            //   7508                 | cmp                 word ptr [edi + 2], 0x54
            //   6a01                 | jne                 0x16
            //   ff15????????         |                     
            //   68????????           |                     
            //   6a01                 | cmp                 word ptr [edi + 6], 0x41

        $sequence_2 = { 6a08 6a18 68???????? 68???????? 68???????? ff15???????? 85c0 }
            // n = 7, score = 1900
            //   6a08                 | jb                  0x1c
            //   6a18                 | cmp                 ecx, 0x7d0
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                edx, edx

        $sequence_3 = { 81b8????????50450000 754c b90b010000 66398818000035 }
            // n = 4, score = 1800
            //   81b8????????50450000     |     
            //   754c                 | jmp                 8
            //   b90b010000           | xor                 eax, eax
            //   66398818000035       | je                  9

        $sequence_4 = { b90b010000 66398818000035 753e 8b4508 }
            // n = 4, score = 1800
            //   b90b010000           | xor                 eax, eax
            //   66398818000035       | je                  9
            //   753e                 | mov                 eax, 1
            //   8b4508               | jmp                 0xd

        $sequence_5 = { ff15???????? 85c0 7407 b801000000 eb0b eb04 }
            // n = 6, score = 1400
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   7407                 | mov                 dword ptr [esp + 0x10], ebp
            //   b801000000           | dec                 ecx
            //   eb0b                 | or                  eax, 0xffffffff
            //   eb04                 | dec                 eax

        $sequence_6 = { e8???????? 68e8030000 ff15???????? 68???????? e8???????? }
            // n = 5, score = 1400
            //   e8????????           |                     
            //   68e8030000           | shr                 eax, 1
            //   ff15????????         |                     
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_7 = { b801000000 eb0b eb04 33c0 eb05 b801000000 }
            // n = 6, score = 1400
            //   b801000000           | dec                 eax
            //   eb0b                 | add                 esp, 0x30
            //   eb04                 | pop                 ebx
            //   33c0                 | ret                 
            //   eb05                 | dec                 eax
            //   b801000000           | mov                 dword ptr [esp + 8], ebx

        $sequence_8 = { c1e100 817c0dd8ff000000 0f8696000000 ba04000000 6bc200 }
            // n = 5, score = 1300
            //   c1e100               | mov                 dword ptr [esp + 0x18], esi
            //   817c0dd8ff000000     | dec                 ecx
            //   0f8696000000         | or                  eax, 0xffffffff
            //   ba04000000           | dec                 eax
            //   6bc200               | mov                 eax, ebx

        $sequence_9 = { 99 89459c 8955a0 8b55a0 3b55f8 0f870b020000 }
            // n = 6, score = 1300
            //   99                   | ret                 
            //   89459c               | dec                 eax
            //   8955a0               | mov                 dword ptr [esp + 8], ebx
            //   8b55a0               | dec                 eax
            //   3b55f8               | mov                 dword ptr [esp + 0x10], ebp
            //   0f870b020000         | dec                 eax

        $sequence_10 = { eb09 8b45f0 83c001 8945f0 8b45f0 99 8b4d08 }
            // n = 7, score = 1300
            //   eb09                 | ret                 
            //   8b45f0               | inc                 eax
            //   83c001               | push                ebx
            //   8945f0               | dec                 eax
            //   8b45f0               | sub                 esp, 0x20
            //   99                   | mov                 eax, ecx
            //   8b4d08               | dec                 eax

        $sequence_11 = { 50 8b4de8 0fb6512c 52 e8???????? }
            // n = 5, score = 1300
            //   50                   | mov                 eax, ebx
            //   8b4de8               | dec                 eax
            //   0fb6512c             | add                 esp, 0x30
            //   52                   | pop                 ebx
            //   e8????????           |                     

        $sequence_12 = { c1e200 8b45fc c6041000 c745d800000000 c745dc00000000 c745e000000000 }
            // n = 6, score = 1300
            //   c1e200               | dec                 eax
            //   8b45fc               | add                 esp, 0x30
            //   c6041000             | pop                 ebx
            //   c745d800000000       | ret                 
            //   c745dc00000000       | dec                 eax
            //   c745e000000000       | mov                 dword ptr [esp + 8], ebx

        $sequence_13 = { ff15???????? b811000000 e9???????? e9???????? }
            // n = 4, score = 1200
            //   ff15????????         |                     
            //   b811000000           | sub                 esp, 0x20
            //   e9????????           |                     
            //   e9????????           |                     

        $sequence_14 = { 6a00 6814010000 ff7508 ff35???????? ff15???????? }
            // n = 5, score = 900
            //   6a00                 | test                eax, eax
            //   6814010000           | jne                 0xc
            //   ff7508               | push                1
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_15 = { ff15???????? 833d????????00 6a10 6a18 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   833d????????00       |                     
            //   6a10                 | mul                 ecx
            //   6a18                 | mov                 eax, ecx

        $sequence_16 = { 7407 48 85c0 7ff0 }
            // n = 4, score = 900
            //   7407                 | add                 eax, edx
            //   48                   | shr                 eax, 6
            //   85c0                 | imul                eax, eax, 0x5a
            //   7ff0                 | mov                 eax, 0x6c16c16d

        $sequence_17 = { ff15???????? b803000000 eb05 b805000000 }
            // n = 4, score = 800
            //   ff15????????         |                     
            //   b803000000           | mov                 eax, 3
            //   eb05                 | jmp                 7
            //   b805000000           | mov                 eax, 5

        $sequence_18 = { 751b ff35???????? ff35???????? 6a01 68???????? e8???????? }
            // n = 6, score = 800
            //   751b                 | push                1
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   6a01                 | push                0x3e8
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_19 = { 2bf0 33c0 66890473 83ffff }
            // n = 4, score = 800
            //   2bf0                 | sub                 esi, eax
            //   33c0                 | xor                 eax, eax
            //   66890473             | mov                 word ptr [ebx + esi*2], ax
            //   83ffff               | cmp                 edi, -1

        $sequence_20 = { 56 ff15???????? 8bcb 8d5102 }
            // n = 4, score = 700
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bcb                 | mov                 ecx, ebx
            //   8d5102               | lea                 edx, [ecx + 2]

        $sequence_21 = { eb0b 8bc1 99 f7fe }
            // n = 4, score = 700
            //   eb0b                 | push                0x18
            //   8bc1                 | push                0x10
            //   99                   | push                1
            //   f7fe                 | push                0

        $sequence_22 = { 7212 81f9d0070000 770a 85d2 }
            // n = 4, score = 700
            //   7212                 | mov                 dword ptr [esp + 0x10], ebp
            //   81f9d0070000         | dec                 eax
            //   770a                 | mov                 dword ptr [esp + 0x18], esi
            //   85d2                 | dec                 ecx

        $sequence_23 = { 85d2 7714 7212 81f9d0070000 }
            // n = 4, score = 700
            //   85d2                 | mov                 eax, ecx
            //   7714                 | ret                 
            //   7212                 | inc                 eax
            //   81f9d0070000         | push                ebx

        $sequence_24 = { e8???????? 488bc3 4883c430 5b c3 48895c2408 48896c2410 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   488bc3               | ret                 
            //   4883c430             | dec                 eax
            //   5b                   | mov                 dword ptr [esp + 8], ebx
            //   c3                   | push                edi
            //   48895c2408           | dec                 eax
            //   48896c2410           | sub                 esp, 0x30

        $sequence_25 = { f3a4 8d7afe 668b4702 8d7f02 }
            // n = 4, score = 600
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d7afe               | lea                 edi, [edx - 2]
            //   668b4702             | mov                 ax, word ptr [edi + 2]
            //   8d7f02               | lea                 edi, [edi + 2]

        $sequence_26 = { 68???????? 53 d1fe e8???????? 83c408 8d5002 }
            // n = 6, score = 600
            //   68????????           |                     
            //   53                   | push                ebx
            //   d1fe                 | sar                 esi, 1
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d5002               | lea                 edx, [eax + 2]

        $sequence_27 = { 4883c428 c3 48895c2408 57 4883ec30 8364242000 b908000000 }
            // n = 7, score = 600
            //   4883c428             | dec                 eax
            //   c3                   | add                 esp, 0x28
            //   48895c2408           | ret                 
            //   57                   | dec                 eax
            //   4883ec30             | mov                 dword ptr [esp + 8], ebx
            //   8364242000           | push                edi
            //   b908000000           | dec                 eax

        $sequence_28 = { 0f9fc0 5d c3 8bff 55 8bec 8b4508 }
            // n = 7, score = 600
            //   0f9fc0               | dec                 eax
            //   5d                   | add                 esp, 0x30
            //   c3                   | pop                 ebx
            //   8bff                 | ret                 
            //   55                   | dec                 eax
            //   8bec                 | mov                 dword ptr [esp + 8], ebx
            //   8b4508               | dec                 eax

        $sequence_29 = { d1fa 2bca 33c0 6689444bfe e9???????? }
            // n = 5, score = 600
            //   d1fa                 | sar                 edx, 1
            //   2bca                 | sub                 ecx, edx
            //   33c0                 | xor                 eax, eax
            //   6689444bfe           | mov                 word ptr [ebx + ecx*2 - 2], ax
            //   e9????????           |                     

        $sequence_30 = { 488b7c2408 498bc1 c3 4053 4883ec20 8bc1 498bd8 }
            // n = 7, score = 600
            //   488b7c2408           | or                  eax, 0xffffffff
            //   498bc1               | dec                 eax
            //   c3                   | mov                 eax, ebx
            //   4053                 | dec                 eax
            //   4883ec20             | add                 esp, 0x30
            //   8bc1                 | pop                 ebx
            //   498bd8               | ret                 

        $sequence_31 = { 6685c0 75f5 8d7bfe 2bd6 8d5f02 668b4702 }
            // n = 6, score = 600
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7
            //   8d7bfe               | lea                 edi, [ebx - 2]
            //   2bd6                 | sub                 edx, esi
            //   8d5f02               | lea                 ebx, [edi + 2]
            //   668b4702             | mov                 ax, word ptr [edi + 2]

        $sequence_32 = { 2bd6 8d5f02 668b4702 83c702 6685c0 75f4 }
            // n = 6, score = 600
            //   2bd6                 | sub                 edx, esi
            //   8d5f02               | lea                 ebx, [edi + 2]
            //   668b4702             | mov                 ax, word ptr [edi + 2]
            //   83c702               | add                 edi, 2
            //   6685c0               | test                ax, ax
            //   75f4                 | jne                 0xfffffff6

        $sequence_33 = { 6685c9 75f5 2bf2 68???????? 53 d1fe }
            // n = 6, score = 600
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   2bf2                 | sub                 esi, edx
            //   68????????           |                     
            //   53                   | push                ebx
            //   d1fe                 | sar                 esi, 1

        $sequence_34 = { 7510 488bcb ff15???????? b802000000 }
            // n = 4, score = 500
            //   7510                 | test                eax, eax
            //   488bcb               | jne                 0xc
            //   ff15????????         |                     
            //   b802000000           | push                1

        $sequence_35 = { 4533c0 c744242003000000 ba00000040 ff15???????? 488bd8 ff15???????? }
            // n = 6, score = 500
            //   4533c0               | push                8
            //   c744242003000000     | push                0x18
            //   ba00000040           | test                eax, eax
            //   ff15????????         |                     
            //   488bd8               | jne                 0x46
            //   ff15????????         |                     

        $sequence_36 = { 8bc1 2bc2 d1e8 03c2 c1e806 6bc05a }
            // n = 6, score = 500
            //   8bc1                 | mov                 dword ptr [esp + 8], ebx
            //   2bc2                 | dec                 eax
            //   d1e8                 | mov                 dword ptr [esp + 0x10], ebp
            //   03c2                 | dec                 eax
            //   c1e806               | mov                 dword ptr [esp + 0x18], esi
            //   6bc05a               | jne                 0x18

        $sequence_37 = { 7516 66837f0254 750f 66837f0641 7508 }
            // n = 5, score = 500
            //   7516                 | mov                 eax, ecx
            //   66837f0254           | ret                 
            //   750f                 | inc                 eax
            //   66837f0641           | push                ebx
            //   7508                 | dec                 eax

        $sequence_38 = { 488bf8 4885c0 7410 ff15???????? }
            // n = 4, score = 500
            //   488bf8               | jne                 0x18
            //   4885c0               | cmp                 word ptr [edi + 2], 0x54
            //   7410                 | jne                 0x18
            //   ff15????????         |                     

        $sequence_39 = { 48897c2430 488d4c2440 c744242802000000 4533c9 4533c0 c744242003000000 ba00000040 }
            // n = 7, score = 500
            //   48897c2430           | push                0
            //   488d4c2440           | push                0x114
            //   c744242802000000     | test                eax, eax
            //   4533c9               | jne                 0xc
            //   4533c0               | push                1
            //   c744242003000000     | push                1
            //   ba00000040           | push                0

        $sequence_40 = { 8b5c3050 ff15???????? 41b900300000 c744242040000000 }
            // n = 4, score = 500
            //   8b5c3050             | add                 esp, 0x28
            //   ff15????????         |                     
            //   41b900300000         | ret                 
            //   c744242040000000     | dec                 eax

        $sequence_41 = { e8???????? 488bcf ff15???????? 8d4301 e9???????? }
            // n = 5, score = 500
            //   e8????????           |                     
            //   488bcf               | jne                 0x5c
            //   ff15????????         |                     
            //   8d4301               | push                1
            //   e9????????           |                     

        $sequence_42 = { ff15???????? 66833f4e 7516 66837f0254 }
            // n = 4, score = 500
            //   ff15????????         |                     
            //   66833f4e             | ret                 
            //   7516                 | inc                 eax
            //   66837f0254           | push                ebx

        $sequence_43 = { 41b900300000 c744242040000000 448bc3 488bd6 }
            // n = 4, score = 500
            //   41b900300000         | test                eax, eax
            //   c744242040000000     | jne                 0xc
            //   448bc3               | push                1
            //   488bd6               | push                1

        $sequence_44 = { 84c0 746c e8???????? 488d0d63080000 e8???????? }
            // n = 5, score = 400
            //   84c0                 | push                1
            //   746c                 | push                0
            //   e8????????           |                     
            //   488d0d63080000       | push                0x114
            //   e8????????           |                     

    condition:
        7 of them and filesize < 7450624
}