rule win_sage_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sage_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sage_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 01442410 ff15???????? 8bc8 8b442410 2b4c2438 }
            // n = 5, score = 300
            //   01442410             | add                 dword ptr [esp + 0x10], eax
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   2b4c2438             | sub                 ecx, dword ptr [esp + 0x38]

        $sequence_1 = { 755b 6683780200 7554 6aff ff15???????? 85c0 }
            // n = 6, score = 300
            //   755b                 | jne                 0x5d
            //   6683780200           | cmp                 word ptr [eax + 2], 0
            //   7554                 | jne                 0x56
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { c1e910 0fb74c4c18 c1e010 0bc8 8bd1 }
            // n = 5, score = 300
            //   c1e910               | shr                 ecx, 0x10
            //   0fb74c4c18           | movzx               ecx, word ptr [esp + ecx*2 + 0x18]
            //   c1e010               | shl                 eax, 0x10
            //   0bc8                 | or                  ecx, eax
            //   8bd1                 | mov                 edx, ecx

        $sequence_3 = { 837c241000 750b 837c241400 0f84d8000000 8b442410 be00000200 3bc6 }
            // n = 7, score = 300
            //   837c241000           | cmp                 dword ptr [esp + 0x10], 0
            //   750b                 | jne                 0xd
            //   837c241400           | cmp                 dword ptr [esp + 0x14], 0
            //   0f84d8000000         | je                  0xde
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   be00000200           | mov                 esi, 0x20000
            //   3bc6                 | cmp                 eax, esi

        $sequence_4 = { bbfdffffff 8d4c240c 51 e8???????? 8d54241c 52 }
            // n = 6, score = 300
            //   bbfdffffff           | mov                 ebx, 0xfffffffd
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx

        $sequence_5 = { 56 57 6af5 ff15???????? 8b15???????? 83c204 52 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   6af5                 | push                -0xb
            //   ff15????????         |                     
            //   8b15????????         |                     
            //   83c204               | add                 edx, 4
            //   52                   | push                edx

        $sequence_6 = { 6a41 56 52 e8???????? 56 }
            // n = 5, score = 300
            //   6a41                 | push                0x41
            //   56                   | push                esi
            //   52                   | push                edx
            //   e8????????           |                     
            //   56                   | push                esi

        $sequence_7 = { 8bf1 33d2 3bf7 732a 8a06 }
            // n = 5, score = 300
            //   8bf1                 | mov                 esi, ecx
            //   33d2                 | xor                 edx, edx
            //   3bf7                 | cmp                 esi, edi
            //   732a                 | jae                 0x2c
            //   8a06                 | mov                 al, byte ptr [esi]

        $sequence_8 = { 014110 8b4314 014114 8b4318 }
            // n = 4, score = 200
            //   014110               | add                 dword ptr [ecx + 0x10], eax
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]
            //   014114               | add                 dword ptr [ecx + 0x14], eax
            //   8b4318               | mov                 eax, dword ptr [ebx + 0x18]

        $sequence_9 = { 014108 8b430c 01410c 8b4310 }
            // n = 4, score = 200
            //   014108               | add                 dword ptr [ecx + 8], eax
            //   8b430c               | mov                 eax, dword ptr [ebx + 0xc]
            //   01410c               | add                 dword ptr [ecx + 0xc], eax
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]

        $sequence_10 = { 01410c 8b4310 014110 8b4314 }
            // n = 4, score = 200
            //   01410c               | add                 dword ptr [ecx + 0xc], eax
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]
            //   014110               | add                 dword ptr [ecx + 0x10], eax
            //   8b4314               | mov                 eax, dword ptr [ebx + 0x14]

        $sequence_11 = { 891c24 89442404 e8???????? 8d964ba20000 c744240879020000 }
            // n = 5, score = 200
            //   891c24               | mov                 dword ptr [esp], ebx
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   8d964ba20000         | lea                 edx, [esi + 0xa24b]
            //   c744240879020000     | mov                 dword ptr [esp + 8], 0x279

        $sequence_12 = { 014114 8b4318 014118 8b431c }
            // n = 4, score = 200
            //   014114               | add                 dword ptr [ecx + 0x14], eax
            //   8b4318               | mov                 eax, dword ptr [ebx + 0x18]
            //   014118               | add                 dword ptr [ecx + 0x18], eax
            //   8b431c               | mov                 eax, dword ptr [ebx + 0x1c]

        $sequence_13 = { 013c13 83c102 46 ebd3 }
            // n = 4, score = 200
            //   013c13               | add                 dword ptr [ebx + edx], edi
            //   83c102               | add                 ecx, 2
            //   46                   | inc                 esi
            //   ebd3                 | jmp                 0xffffffd5

        $sequence_14 = { 0101 8b4304 014104 8b4308 014108 }
            // n = 5, score = 200
            //   0101                 | add                 dword ptr [ecx], eax
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   014104               | add                 dword ptr [ecx + 4], eax
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   014108               | add                 dword ptr [ecx + 8], eax

        $sequence_15 = { 0119 117104 83c110 83c210 }
            // n = 4, score = 200
            //   0119                 | add                 dword ptr [ecx], ebx
            //   117104               | adc                 dword ptr [ecx + 4], esi
            //   83c110               | add                 ecx, 0x10
            //   83c210               | add                 edx, 0x10

    condition:
        7 of them and filesize < 335872
}