rule win_sagerunex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sagerunex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sagerunex"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 0fb74b02 4803cb e8???????? 8d7701 ba04010000 e9???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0fb74b02             | je                  0xebc
            //   4803cb               | dec                 eax
            //   e8????????           |                     
            //   8d7701               | mov                 dword ptr [esp + 0x1c0], ebx
            //   ba04010000           | dec                 eax
            //   e9????????           |                     

        $sequence_1 = { 8bc7 ffc7 3d00010000 0f8f2a030000 488bcb e8???????? 85c0 }
            // n = 7, score = 100
            //   8bc7                 | mov                 eax, 1
            //   ffc7                 | dec                 eax
            //   3d00010000           | mov                 ecx, dword ptr [esp + 0x660]
            //   0f8f2a030000         | dec                 eax
            //   488bcb               | xor                 ecx, esp
            //   e8????????           |                     
            //   85c0                 | dec                 eax

        $sequence_2 = { 4156 4157 4881ec60020000 488b05???????? 4833c4 4889842450020000 4d8bf1 }
            // n = 7, score = 100
            //   4156                 | mov                 edx, dword ptr [ebx + 0x10]
            //   4157                 | dec                 eax
            //   4881ec60020000       | test                edx, edx
            //   488b05????????       |                     
            //   4833c4               | je                  0x5d1
            //   4889842450020000     | dec                 esp
            //   4d8bf1               | mov                 eax, dword ptr [ebx + 8]

        $sequence_3 = { 448bc3 e8???????? 33c0 c744242801234567 c744242c89abcdef c7442430fedcba98 c744243476543210 }
            // n = 7, score = 100
            //   448bc3               | lea                 edx, [esp + 0x20]
            //   e8????????           |                     
            //   33c0                 | dec                 eax
            //   c744242801234567     | add                 ecx, eax
            //   c744242c89abcdef     | dec                 esp
            //   c7442430fedcba98     | mov                 eax, esi
            //   c744243476543210     | dec                 eax

        $sequence_4 = { b801000000 488b8c2490000000 4833cc e8???????? 488b9c24d8000000 4881c4a0000000 5f }
            // n = 7, score = 100
            //   b801000000           | dec                 eax
            //   488b8c2490000000     | lea                 ecx, [0x329fb]
            //   4833cc               | mov                 edx, eax
            //   e8????????           |                     
            //   488b9c24d8000000     | dec                 eax
            //   4881c4a0000000       | mov                 ecx, dword ptr [ebx + 0x290]
            //   5f                   | xor                 edx, edx

        $sequence_5 = { 41b8000c0000 c744247001000000 48ffc3 4889442478 48894580 c744245001000000 4889442458 }
            // n = 7, score = 100
            //   41b8000c0000         | lea                 esi, [ebp - 0x50]
            //   c744247001000000     | dec                 eax
            //   48ffc3               | lea                 esi, [esi + eax*2]
            //   4889442478           | dec                 eax
            //   48894580             | lea                 ecx, [0x35418]
            //   c744245001000000     | inc                 ecx
            //   4889442458           | mov                 dword ptr [esi + 0xc844], 7

        $sequence_6 = { 488bcf 7512 e8???????? 85c0 751e 488d0d6e500300 eb8a }
            // n = 7, score = 100
            //   488bcf               | mov                 edx, dword ptr [ebp - 0x78]
            //   7512                 | dec                 esp
            //   e8????????           |                     
            //   85c0                 | mov                 dword ptr [ebp + 0x58], ebx
            //   751e                 | dec                 eax
            //   488d0d6e500300       | test                edx, edx
            //   eb8a                 | dec                 esp

        $sequence_7 = { 4983d300 4d034838 4d3b4838 4d894838 4983d300 4983c040 49ffcf }
            // n = 7, score = 100
            //   4983d300             | pop                 edi
            //   4d034838             | jne                 0x5d6
            //   4d3b4838             | dec                 eax
            //   4d894838             | mov                 ebx, dword ptr [esp + 0x170]
            //   4983d300             | dec                 eax
            //   4983c040             | lea                 eax, [esp + 0x20]
            //   49ffcf               | nop                 dword ptr [eax]

        $sequence_8 = { f0ff00 488d4128 41b806000000 488d1560db0100 483950f0 740b 488b10 }
            // n = 7, score = 100
            //   f0ff00               | xor                 edi, dword ptr [eax]
            //   488d4128             | dec                 eax
            //   41b806000000         | shr                 ecx, 8
            //   488d1560db0100       | inc                 esp
            //   483950f0             | movzx               eax, cl
            //   740b                 | inc                 ecx
            //   488b10               | mov                 ecx, ecx

        $sequence_9 = { 03d8 41bc67666666 41b80d000000 f20f11450a f20f1005???????? 418bc4 4c8d4d90 }
            // n = 7, score = 100
            //   03d8                 | dec                 eax
            //   41bc67666666         | mov                 ebx, ebp
            //   41b80d000000         | dec                 eax
            //   f20f11450a           | sub                 ebp, ebx
            //   f20f1005????????     |                     
            //   418bc4               | dec                 eax
            //   4c8d4d90             | add                 ebp, 7

    condition:
        7 of them and filesize < 619520
}