rule win_saint_bot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.saint_bot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.saint_bot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 ff15???????? 6800018000 eb11 6a50 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   6800018000           | push                0x800100
            //   eb11                 | jmp                 0x13
            //   6a50                 | push                0x50

        $sequence_1 = { 668975d4 8d4508 33f6 c745b418000000 683f000f00 50 }
            // n = 6, score = 100
            //   668975d4             | mov                 word ptr [ebp - 0x2c], si
            //   8d4508               | lea                 eax, [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   c745b418000000       | mov                 dword ptr [ebp - 0x4c], 0x18
            //   683f000f00           | push                0xf003f
            //   50                   | push                eax

        $sequence_2 = { 3d2b040000 7415 3d3f040000 740e }
            // n = 4, score = 100
            //   3d2b040000           | cmp                 eax, 0x42b
            //   7415                 | je                  0x17
            //   3d3f040000           | cmp                 eax, 0x43f
            //   740e                 | je                  0x10

        $sequence_3 = { 8945f8 e8???????? 68???????? 8945f0 }
            // n = 4, score = 100
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   68????????           |                     
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_4 = { 56 ff15???????? ff15???????? 3db7000000 741c }
            // n = 5, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   741c                 | je                  0x1e

        $sequence_5 = { 58 6a6e 668945f0 58 6a74 668945f2 }
            // n = 6, score = 100
            //   58                   | pop                 eax
            //   6a6e                 | push                0x6e
            //   668945f0             | mov                 word ptr [ebp - 0x10], ax
            //   58                   | pop                 eax
            //   6a74                 | push                0x74
            //   668945f2             | mov                 word ptr [ebp - 0xe], ax

        $sequence_6 = { 6a00 56 68???????? 53 ff15???????? 8bf0 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   56                   | push                esi
            //   68????????           |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_7 = { 897dec 897df8 ffd6 6808020000 57 8bd8 ffd6 }
            // n = 7, score = 100
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   ffd6                 | call                esi
            //   6808020000           | push                0x208
            //   57                   | push                edi
            //   8bd8                 | mov                 ebx, eax
            //   ffd6                 | call                esi

        $sequence_8 = { ff75dc ffd6 ff75d4 ffd6 e8???????? }
            // n = 5, score = 100
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ffd6                 | call                esi
            //   ff75d4               | push                dword ptr [ebp - 0x2c]
            //   ffd6                 | call                esi
            //   e8????????           |                     

        $sequence_9 = { ffd6 ff75f0 ffd6 ff75f4 ffd6 ff75f8 ffd6 }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ffd6                 | call                esi
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ffd6                 | call                esi
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 93184
}