rule win_sanny_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sanny."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sanny"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 56 e8???????? 8b4c2434 8b542430 51 52 }
            // n = 7, score = 100
            //   68????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   8b542430             | mov                 edx, dword ptr [esp + 0x30]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_1 = { 8b4c240c 6a05 51 8bce }
            // n = 4, score = 100
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   6a05                 | push                5
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi

        $sequence_2 = { 8d4c241c 51 8d542444 6a00 8d4c2434 52 51 }
            // n = 7, score = 100
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   51                   | push                ecx
            //   8d542444             | lea                 edx, [esp + 0x44]
            //   6a00                 | push                0
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   52                   | push                edx
            //   51                   | push                ecx

        $sequence_3 = { 894614 83c002 50 e8???????? 8b4e14 83c404 41 }
            // n = 7, score = 100
            //   894614               | mov                 dword ptr [esi + 0x14], eax
            //   83c002               | add                 eax, 2
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   83c404               | add                 esp, 4
            //   41                   | inc                 ecx

        $sequence_4 = { eb63 3c02 755f 8b861cc70000 85c0 7455 8b542408 }
            // n = 7, score = 100
            //   eb63                 | jmp                 0x65
            //   3c02                 | cmp                 al, 2
            //   755f                 | jne                 0x61
            //   8b861cc70000         | mov                 eax, dword ptr [esi + 0xc71c]
            //   85c0                 | test                eax, eax
            //   7455                 | je                  0x57
            //   8b542408             | mov                 edx, dword ptr [esp + 8]

        $sequence_5 = { 8b542410 52 ffd5 8d442414 43 50 53 }
            // n = 7, score = 100
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   52                   | push                edx
            //   ffd5                 | call                ebp
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   43                   | inc                 ebx
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_6 = { 8b54244c 8d442454 8d4c240c 50 51 8d442428 52 }
            // n = 7, score = 100
            //   8b54244c             | mov                 edx, dword ptr [esp + 0x4c]
            //   8d442454             | lea                 eax, [esp + 0x54]
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   52                   | push                edx

        $sequence_7 = { 81ec08040000 8d442400 56 8bb42414040000 50 8b842420040000 8d54240c }
            // n = 7, score = 100
            //   81ec08040000         | sub                 esp, 0x408
            //   8d442400             | lea                 eax, [esp]
            //   56                   | push                esi
            //   8bb42414040000       | mov                 esi, dword ptr [esp + 0x414]
            //   50                   | push                eax
            //   8b842420040000       | mov                 eax, dword ptr [esp + 0x420]
            //   8d54240c             | lea                 edx, [esp + 0xc]

        $sequence_8 = { 53 57 8d3c85c4714100 bb00100000 7520 53 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d3c85c4714100       | lea                 edi, [eax*4 + 0x4171c4]
            //   bb00100000           | mov                 ebx, 0x1000
            //   7520                 | jne                 0x22
            //   53                   | push                ebx

        $sequence_9 = { 8d3449 2bd1 8d34b530634100 832600 83c60c 4a 75f7 }
            // n = 7, score = 100
            //   8d3449               | lea                 esi, [ecx + ecx*2]
            //   2bd1                 | sub                 edx, ecx
            //   8d34b530634100       | lea                 esi, [esi*4 + 0x416330]
            //   832600               | and                 dword ptr [esi], 0
            //   83c60c               | add                 esi, 0xc
            //   4a                   | dec                 edx
            //   75f7                 | jne                 0xfffffff9

    condition:
        7 of them and filesize < 253952
}