rule win_satana_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.satana."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.satana"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 9c 90 8b1d???????? 6a00 }
            // n = 4, score = 100
            //   9c                   | pushfd              
            //   90                   | nop                 
            //   8b1d????????         |                     
            //   6a00                 | push                0

        $sequence_1 = { 50 68???????? a3???????? e8???????? 83c408 03df }
            // n = 6, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   03df                 | add                 ebx, edi

        $sequence_2 = { a1???????? 6a00 03d2 52 50 ffd6 8b55ec }
            // n = 7, score = 100
            //   a1????????           |                     
            //   6a00                 | push                0
            //   03d2                 | add                 edx, edx
            //   52                   | push                edx
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]

        $sequence_3 = { 83c404 8bf0 660f57c0 660f1345c4 8b5dc4 8b7dac }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   8bf0                 | mov                 esi, eax
            //   660f57c0             | xorpd               xmm0, xmm0
            //   660f1345c4           | movlpd              qword ptr [ebp - 0x3c], xmm0
            //   8b5dc4               | mov                 ebx, dword ptr [ebp - 0x3c]
            //   8b7dac               | mov                 edi, dword ptr [ebp - 0x54]

        $sequence_4 = { f7c200000002 7436 660f2805???????? 90 }
            // n = 4, score = 100
            //   f7c200000002         | test                edx, 0x2000000
            //   7436                 | je                  0x38
            //   660f2805????????     |                     
            //   90                   | nop                 

        $sequence_5 = { 0fb64c0de8 c1ea04 0fb65415e8 8850ff 8808 0fb64c35ae }
            // n = 6, score = 100
            //   0fb64c0de8           | movzx               ecx, byte ptr [ebp + ecx - 0x18]
            //   c1ea04               | shr                 edx, 4
            //   0fb65415e8           | movzx               edx, byte ptr [ebp + edx - 0x18]
            //   8850ff               | mov                 byte ptr [eax - 1], dl
            //   8808                 | mov                 byte ptr [eax], cl
            //   0fb64c35ae           | movzx               ecx, byte ptr [ebp + esi - 0x52]

        $sequence_6 = { 50 68???????? e8???????? 83c414 eb14 ff15???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   eb14                 | jmp                 0x16
            //   ff15????????         |                     

        $sequence_7 = { 83c404 68???????? eb33 8d4db0 51 }
            // n = 5, score = 100
            //   83c404               | add                 esp, 4
            //   68????????           |                     
            //   eb33                 | jmp                 0x35
            //   8d4db0               | lea                 ecx, [ebp - 0x50]
            //   51                   | push                ecx

        $sequence_8 = { 8bc8 d1e8 83e101 33048d00904000 3305???????? a3???????? 33c0 }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   d1e8                 | shr                 eax, 1
            //   83e101               | and                 ecx, 1
            //   33048d00904000       | xor                 eax, dword ptr [ecx*4 + 0x409000]
            //   3305????????         |                     
            //   a3????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { 57 8d45fc 50 3308 db6819 203c53 6840200800 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   3308                 | xor                 ecx, dword ptr [eax]
            //   db6819               | fld                 xword ptr [eax + 0x19]
            //   203c53               | and                 byte ptr [ebx + edx*2], bh
            //   6840200800           | push                0x82040

    condition:
        7 of them and filesize < 221184
}