rule win_satellite_turla_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.satellite_turla."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.satellite_turla"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0108 833e00 7c1f 8b542410 }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7c1f                 | jl                  0x21
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]

        $sequence_1 = { 0105???????? 81c3b0020000 2945e0 75ae 837dd400 }
            // n = 5, score = 200
            //   0105????????         |                     
            //   81c3b0020000         | add                 ebx, 0x2b0
            //   2945e0               | sub                 dword ptr [ebp - 0x20], eax
            //   75ae                 | jne                 0xffffffb0
            //   837dd400             | cmp                 dword ptr [ebp - 0x2c], 0

        $sequence_2 = { 0105???????? 83c410 29442418 75a9 }
            // n = 4, score = 200
            //   0105????????         |                     
            //   83c410               | add                 esp, 0x10
            //   29442418             | sub                 dword ptr [esp + 0x18], eax
            //   75a9                 | jne                 0xffffffab

        $sequence_3 = { 0108 833e00 7fc7 db46fc }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7fc7                 | jg                  0xffffffc9
            //   db46fc               | fild                dword ptr [esi - 4]

        $sequence_4 = { 0105???????? 83c410 29442420 75aa }
            // n = 4, score = 200
            //   0105????????         |                     
            //   83c410               | add                 esp, 0x10
            //   29442420             | sub                 dword ptr [esp + 0x20], eax
            //   75aa                 | jne                 0xffffffac

        $sequence_5 = { 0108 833a00 7c23 8b442428 }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   833a00               | cmp                 dword ptr [edx], 0
            //   7c23                 | jl                  0x25
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]

        $sequence_6 = { 51 8d951cffffff 52 eb2b 8b4d20 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   8d951cffffff         | lea                 edx, [ebp - 0xe4]
            //   52                   | push                edx
            //   eb2b                 | jmp                 0x2d
            //   8b4d20               | mov                 ecx, dword ptr [ebp + 0x20]

        $sequence_7 = { 0108 833e00 7cc7 7e39 }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7cc7                 | jl                  0xffffffc9
            //   7e39                 | jle                 0x3b

        $sequence_8 = { 66ab aa 8b3d???????? 8d85f0feffff 56 }
            // n = 5, score = 100
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8b3d????????         |                     
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   56                   | push                esi

        $sequence_9 = { ffd7 53 56 ff15???????? 6a02 53 56 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   53                   | push                ebx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6a02                 | push                2
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_10 = { ff15???????? ff45fc 817dfc88130000 7cb7 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   817dfc88130000       | cmp                 dword ptr [ebp - 4], 0x1388
            //   7cb7                 | jl                  0xffffffb9

        $sequence_11 = { c645d205 c645d337 c645d418 c645d51d c645d614 c645d722 }
            // n = 6, score = 100
            //   c645d205             | mov                 byte ptr [ebp - 0x2e], 5
            //   c645d337             | mov                 byte ptr [ebp - 0x2d], 0x37
            //   c645d418             | mov                 byte ptr [ebp - 0x2c], 0x18
            //   c645d51d             | mov                 byte ptr [ebp - 0x2b], 0x1d
            //   c645d614             | mov                 byte ptr [ebp - 0x2a], 0x14
            //   c645d722             | mov                 byte ptr [ebp - 0x29], 0x22

        $sequence_12 = { e8???????? ff75fc 8945f8 53 50 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   53                   | push                ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_13 = { 57 ffd6 a3???????? 6a71 8d45d0 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   a3????????           |                     
            //   6a71                 | push                0x71
            //   8d45d0               | lea                 eax, [ebp - 0x30]

        $sequence_14 = { c645b816 c645b927 c645ba30 c645bb34 c645bc21 c645bd30 }
            // n = 6, score = 100
            //   c645b816             | mov                 byte ptr [ebp - 0x48], 0x16
            //   c645b927             | mov                 byte ptr [ebp - 0x47], 0x27
            //   c645ba30             | mov                 byte ptr [ebp - 0x46], 0x30
            //   c645bb34             | mov                 byte ptr [ebp - 0x45], 0x34
            //   c645bc21             | mov                 byte ptr [ebp - 0x44], 0x21
            //   c645bd30             | mov                 byte ptr [ebp - 0x43], 0x30

        $sequence_15 = { 8d45c4 885dcf 50 57 }
            // n = 4, score = 100
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   885dcf               | mov                 byte ptr [ebp - 0x31], bl
            //   50                   | push                eax
            //   57                   | push                edi

    condition:
        7 of them and filesize < 1040384
}