rule win_scanline_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scanline."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scanline"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7404 8b400c c3 33c0 c3 83611000 c3 }
            // n = 7, score = 100
            //   7404                 | je                  6
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   83611000             | and                 dword ptr [ecx + 0x10], 0
            //   c3                   | ret                 

        $sequence_1 = { 740e 53 8bc8 ff742414 e8???????? eb02 }
            // n = 6, score = 100
            //   740e                 | je                  0x10
            //   53                   | push                ebx
            //   8bc8                 | mov                 ecx, eax
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   eb02                 | jmp                 4

        $sequence_2 = { 8bd8 85db 743d 6800040000 8d4608 ff7508 }
            // n = 6, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   743d                 | je                  0x3f
            //   6800040000           | push                0x400
            //   8d4608               | lea                 eax, [esi + 8]
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_3 = { 7434 6a10 e8???????? 3bc3 59 740e 53 }
            // n = 7, score = 100
            //   7434                 | je                  0x36
            //   6a10                 | push                0x10
            //   e8????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   59                   | pop                 ecx
            //   740e                 | je                  0x10
            //   53                   | push                ebx

        $sequence_4 = { 750f 83f81f 730a 885c0438 8a1f 40 }
            // n = 6, score = 100
            //   750f                 | jne                 0x11
            //   83f81f               | cmp                 eax, 0x1f
            //   730a                 | jae                 0xc
            //   885c0438             | mov                 byte ptr [esp + eax + 0x38], bl
            //   8a1f                 | mov                 bl, byte ptr [edi]
            //   40                   | inc                 eax

        $sequence_5 = { 7e10 894608 c1e003 50 e8???????? 59 894604 }
            // n = 7, score = 100
            //   7e10                 | jle                 0x12
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   c1e003               | shl                 eax, 3
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_6 = { 59 59 8b45fc a3???????? e9???????? c705????????01000000 e9???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   a3????????           |                     
            //   e9????????           |                     
            //   c705????????01000000     |     
            //   e9????????           |                     

        $sequence_7 = { 8bc8 c1e103 8bd1 89460c 33c0 c1e902 }
            // n = 6, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   c1e103               | shl                 ecx, 3
            //   8bd1                 | mov                 edx, ecx
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   33c0                 | xor                 eax, eax
            //   c1e902               | shr                 ecx, 2

        $sequence_8 = { 51 bbffff0000 6806100000 53 50 ffd7 8d8608050000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   bbffff0000           | mov                 ebx, 0xffff
            //   6806100000           | push                0x1006
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8d8608050000         | lea                 eax, [esi + 0x508]

        $sequence_9 = { 8b4e18 50 e8???????? 6a24 e8???????? 8bf8 59 }
            // n = 7, score = 100
            //   8b4e18               | mov                 ecx, dword ptr [esi + 0x18]
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a24                 | push                0x24
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   59                   | pop                 ecx

    condition:
        7 of them and filesize < 151552
}