rule win_scarecrow_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scarecrow."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scarecrow"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c645d951 c645da70 c645db4c c645dc70 c645dd2b c645de70 c645df16 }
            // n = 7, score = 100
            //   c645d951             | mov                 byte ptr [ebp - 0x27], 0x51
            //   c645da70             | mov                 byte ptr [ebp - 0x26], 0x70
            //   c645db4c             | mov                 byte ptr [ebp - 0x25], 0x4c
            //   c645dc70             | mov                 byte ptr [ebp - 0x24], 0x70
            //   c645dd2b             | mov                 byte ptr [ebp - 0x23], 0x2b
            //   c645de70             | mov                 byte ptr [ebp - 0x22], 0x70
            //   c645df16             | mov                 byte ptr [ebp - 0x21], 0x16

        $sequence_1 = { c645d55b c645d678 c645d77c c645d878 c645d928 c645da78 c645db7c }
            // n = 7, score = 100
            //   c645d55b             | mov                 byte ptr [ebp - 0x2b], 0x5b
            //   c645d678             | mov                 byte ptr [ebp - 0x2a], 0x78
            //   c645d77c             | mov                 byte ptr [ebp - 0x29], 0x7c
            //   c645d878             | mov                 byte ptr [ebp - 0x28], 0x78
            //   c645d928             | mov                 byte ptr [ebp - 0x27], 0x28
            //   c645da78             | mov                 byte ptr [ebp - 0x26], 0x78
            //   c645db7c             | mov                 byte ptr [ebp - 0x25], 0x7c

        $sequence_2 = { 40 74ec 5f 5e b801000000 5b }
            // n = 6, score = 100
            //   40                   | inc                 eax
            //   74ec                 | je                  0xffffffee
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx

        $sequence_3 = { 56 6a49 68d340dedd ba0f000000 8bf1 e8???????? 83c408 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   6a49                 | push                0x49
            //   68d340dedd           | push                0xddde40d3
            //   ba0f000000           | mov                 edx, 0xf
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_4 = { 99 f7fb 85d2 74d8 8a06 8bde 84c0 }
            // n = 7, score = 100
            //   99                   | cdq                 
            //   f7fb                 | idiv                ebx
            //   85d2                 | test                edx, edx
            //   74d8                 | je                  0xffffffda
            //   8a06                 | mov                 al, byte ptr [esi]
            //   8bde                 | mov                 ebx, esi
            //   84c0                 | test                al, al

        $sequence_5 = { 757b b905000000 8b45fc 99 f7f9 85d2 7405 }
            // n = 7, score = 100
            //   757b                 | jne                 0x7d
            //   b905000000           | mov                 ecx, 5
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx
            //   85d2                 | test                edx, edx
            //   7405                 | je                  7

        $sequence_6 = { be05000000 0f1f440000 8b45b8 99 f7fe 85d2 7405 }
            // n = 7, score = 100
            //   be05000000           | mov                 esi, 5
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   99                   | cdq                 
            //   f7fe                 | idiv                esi
            //   85d2                 | test                edx, edx
            //   7405                 | je                  7

        $sequence_7 = { 59 e9???????? c745dc03000000 eb7c c745e030024300 ebbb d9e8 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   e9????????           |                     
            //   c745dc03000000       | mov                 dword ptr [ebp - 0x24], 3
            //   eb7c                 | jmp                 0x7e
            //   c745e030024300       | mov                 dword ptr [ebp - 0x20], 0x430230
            //   ebbb                 | jmp                 0xffffffbd
            //   d9e8                 | fld1                

        $sequence_8 = { c745e030024300 e9???????? 83e80f 7451 83e809 7443 83e801 }
            // n = 7, score = 100
            //   c745e030024300       | mov                 dword ptr [ebp - 0x20], 0x430230
            //   e9????????           |                     
            //   83e80f               | sub                 eax, 0xf
            //   7451                 | je                  0x53
            //   83e809               | sub                 eax, 9
            //   7443                 | je                  0x45
            //   83e801               | sub                 eax, 1

        $sequence_9 = { 7528 e8???????? 85c0 0f847f020000 e8???????? 6a4d }
            // n = 6, score = 100
            //   7528                 | jne                 0x2a
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f847f020000         | je                  0x285
            //   e8????????           |                     
            //   6a4d                 | push                0x4d

    condition:
        7 of them and filesize < 501760
}