rule win_scavenger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scavenger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scavenger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb6c0 85c0 7421 488b442430 488b00 4889442458 488b442458 }
            // n = 7, score = 900
            //   0fb6c0               | lea                 ecx, [ebp + 0xf608]
            //   85c0                 | dec                 eax
            //   7421                 | add                 esp, 0x28
            //   488b442430           | inc                 ecx
            //   488b00               | pop                 ebp
            //   4889442458           | dec                 eax
            //   488b442458           | lea                 ebp, [edx + 0x60]

        $sequence_1 = { 488b442428 48c7401800000000 488b8424a8000000 488b4010 4889442470 488b8424a8000000 4889442430 }
            // n = 7, score = 900
            //   488b442428           | mov                 al, byte ptr [ecx + 0x18]
            //   48c7401800000000     | inc                 ecx
            //   488b8424a8000000     | mov                 byte ptr [eax + ecx + 0x30], al
            //   488b4010             | dec                 eax
            //   4889442470           | cmp                 edi, 0x101
            //   488b8424a8000000     | jl                  0xeb0
            //   4889442430           | dec                 eax

        $sequence_2 = { 4889442420 488b8c2410010000 e8???????? 4839842420010000 7606 e8???????? }
            // n = 6, score = 900
            //   4889442420           | mov                 eax, ecx
            //   488b8c2410010000     | dec                 eax
            //   e8????????           |                     
            //   4839842420010000     | mov                 dword ptr [ebp + 0x2598], eax
            //   7606                 | mov                 eax, dword ptr [ebp + eax + 0xf180]
            //   e8????????           |                     

        $sequence_3 = { 4889442440 488b442430 4883c010 4889442448 }
            // n = 4, score = 900
            //   4889442440           | dec                 eax
            //   488b442430           | mov                 ecx, dword ptr [esp + 0x20]
            //   4883c010             | dec                 eax
            //   4889442448           | lea                 edx, [0x1004bd]

        $sequence_4 = { 4889442438 e9???????? 33d2 b80f000000 b902000000 48f7f1 488b4c2430 }
            // n = 7, score = 900
            //   4889442438           | mov                 ecx, esi
            //   e9????????           |                     
            //   33d2                 | test                eax, eax
            //   b80f000000           | je                  0x1913
            //   b902000000           | je                  0x1928
            //   48f7f1               | dec                 eax
            //   488b4c2430           | lea                 edx, [0x39ec9]

        $sequence_5 = { 488b442428 48c7401800000000 488b8424a8000000 488b4010 }
            // n = 4, score = 900
            //   488b442428           | dec                 eax
            //   48c7401800000000     | mov                 dword ptr [ebp + 0x3a68], 0
            //   488b8424a8000000     | dec                 eax
            //   488b4010             | mov                 dword ptr [ebp + 0x13a68], eax

        $sequence_6 = { 4889442420 488b442420 4889442448 488b442420 4883c008 4889442450 }
            // n = 6, score = 900
            //   4889442420           | mov                 ecx, dword ptr [ebp + 0xd60]
            //   488b442420           | dec                 eax
            //   4889442448           | add                 ecx, eax
            //   488b442420           | dec                 eax
            //   4883c008             | mov                 eax, ecx
            //   4889442450           | dec                 eax

        $sequence_7 = { 4889442468 48c7442430ffffffff 488b442430 4889442478 }
            // n = 4, score = 900
            //   4889442468           | dec                 eax
            //   48c7442430ffffffff     | cmp    dword ptr [ebp + 0x3eb8], 3
            //   488b442430           | jae                 0x1bf1
            //   4889442478           | dec                 eax

        $sequence_8 = { 488378180f 760a c744243001000000 eb08 c744243000000000 0fb6442430 88442420 }
            // n = 7, score = 900
            //   488378180f           | pop                 ebx
            //   760a                 | ret                 
            //   c744243001000000     | dec                 eax
            //   eb08                 | and                 dword ptr [ecx + 0x10], 0
            //   c744243000000000     | dec                 eax
            //   0fb6442430           | lea                 eax, [0x4539c]
            //   88442420             | dec                 eax

        $sequence_9 = { 4883ec60 488b442470 4889442448 488b442478 4889442438 488b442438 }
            // n = 6, score = 900
            //   4883ec60             | dec                 eax
            //   488b442470           | add                 ecx, eax
            //   4889442448           | dec                 eax
            //   488b442478           | mov                 eax, ecx
            //   4889442438           | dec                 eax
            //   488b442438           | mov                 dword ptr [ebp + 0x3a0], eax

    condition:
        7 of them and filesize < 2992128
}