rule win_scoring_math_tea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.scoring_math_tea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scoring_math_tea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 448bfe 448be6 89742450 4889b42420010000 0f57c0 f30f7f842430010000 4533c0 }
            // n = 7, score = 100
            //   448bfe               | mov                 ecx, edi
            //   448be6               | mov                 edx, 0x7530
            //   89742450             | dec                 eax
            //   4889b42420010000     | mov                 ecx, edi
            //   0f57c0               | call                eax
            //   f30f7f842430010000     | cmp    eax, 0x102
            //   4533c0               | je                  0x1c6e

        $sequence_1 = { 66894dea 488d4de0 0fb700 668945ec 33c0 }
            // n = 5, score = 100
            //   66894dea             | dec                 eax
            //   488d4de0             | lea                 edx, [0x55176]
            //   0fb700               | dec                 eax
            //   668945ec             | mov                 ecx, ebx
            //   33c0                 | dec                 eax

        $sequence_2 = { 4889458c 33c0 894594 66894598 48b85700650064000000 4889459a 33c0 }
            // n = 7, score = 100
            //   4889458c             | mov                 ecx, edx
            //   33c0                 | inc                 ecx
            //   894594               | call                edi
            //   66894598             | jmp                 0xac0
            //   48b85700650064000000     | bt    edx, 0x1a
            //   4889459a             | mov                 edx, dword ptr [ebx]
            //   33c0                 | inc                 esp

        $sequence_3 = { 83ef01 7986 4885db 743d 488b45af 482bc3 48c1f802 }
            // n = 7, score = 100
            //   83ef01               | dec                 ecx
            //   7986                 | arpl                cx, ax
            //   4885db               | inc                 ecx
            //   743d                 | lea                 ecx, [ecx + 0x102]
            //   488b45af             | dec                 esp
            //   482bc3               | lea                 ecx, [edi - 0x102]
            //   48c1f802             | cmp                 ecx, ebx

        $sequence_4 = { 83e00a eb09 33c0 eb05 b80a000000 488b5c2430 }
            // n = 6, score = 100
            //   83e00a               | mov                 eax, 0x7b2
            //   eb09                 | inc                 ecx
            //   33c0                 | mov                 ecx, 1
            //   eb05                 | cmp                 cx, ax
            //   b80a000000           | dec                 eax
            //   488b5c2430           | lea                 ecx, [ebp - 0x4c]

        $sequence_5 = { e8???????? 90 488d4c2420 e8???????? 4889742420 4889742430 4889742438 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | cmp                 dword ptr [ebx + 0x1af90], 0
            //   488d4c2420           | jae                 0x40
            //   e8????????           |                     
            //   4889742420           | inc                 ecx
            //   4889742430           | movzx               edx, cx
            //   4889742438           | mov                 word ptr [ebp - 0x48], ax

        $sequence_6 = { 49ffc6 4183c708 443b3a 72d7 8b02 }
            // n = 5, score = 100
            //   49ffc6               | dec                 eax
            //   4183c708             | inc                 eax
            //   443b3a               | dec                 eax
            //   72d7                 | mov                 ebx, dword ptr [esp + 0x40]
            //   8b02                 | xor                 edx, edx

        $sequence_7 = { 410fb702 6643390413 7515 4983c202 4883ef01 75eb 4c8bc1 }
            // n = 7, score = 100
            //   410fb702             | mov                 dword ptr [esp + 0x30], esp
            //   6643390413           | mov                 eax, dword ptr [esp + 0x50]
            //   7515                 | dec                 eax
            //   4983c202             | lea                 ecx, [ebp + 0x3f0]
            //   4883ef01             | mov                 ecx, 0xc0adc286
            //   75eb                 | dec                 eax
            //   4c8bc1               | mov                 ecx, dword ptr [edi + 0x1d]

        $sequence_8 = { e8???????? 458d41ff 41bfffff0000 8d7a02 4963c8 664139b44a18100000 7511 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   458d41ff             | dec                 esp
            //   41bfffff0000         | lea                 eax, [ebp + 0x350]
            //   8d7a02               | inc                 ecx
            //   4963c8               | mov                 edx, esi
            //   664139b44a18100000     | dec    eax
            //   7511                 | mov                 ecx, ebx

        $sequence_9 = { 49ffc1 413801 7513 4883c108 49ffc1 8a01 413801 }
            // n = 7, score = 100
            //   49ffc1               | inc                 esp
            //   413801               | mov                 dword ptr [ebp + 0x170], esp
            //   7513                 | jmp                 0xf46
            //   4883c108             | neg                 ecx
            //   49ffc1               | dec                 esp
            //   8a01                 | lea                 eax, [0xfffc3230]
            //   413801               | mul                 ecx

    condition:
        7 of them and filesize < 881664
}