rule win_sdbbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sdbbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sdbbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03f3 8b17 03d3 33c9 8a02 }
            // n = 5, score = 700
            //   03f3                 | jmp                 0xffffffe4
            //   8b17                 | mov                 eax, dword ptr fs:[0x30]
            //   03d3                 | mov                 dword ptr [ebp - 8], edi
            //   33c9                 | mov                 dword ptr [edi], eax
            //   8a02                 | add                 edi, 4

        $sequence_1 = { 8b5df0 8bbb80000000 03fe 897dec 833f00 0f847d000000 }
            // n = 6, score = 700
            //   8b5df0               | test                esi, esi
            //   8bbb80000000         | lea                 eax, [esi + 4]
            //   03fe                 | je                  0x15
            //   897dec               | mov                 al, byte ptr [edx]
            //   833f00               | lea                 ecx, [ecx + 1]
            //   0f847d000000         | mov                 byte ptr [ecx - 1], al

        $sequence_2 = { 2b7b34 8955ec 85d2 0f84ae000000 8b83a0000000 03c6 }
            // n = 6, score = 700
            //   2b7b34               | mov                 ebx, dword ptr [ebp - 0x10]
            //   8955ec               | mov                 edi, dword ptr [ebx + 0x80]
            //   85d2                 | add                 edi, esi
            //   0f84ae000000         | mov                 dword ptr [ebp - 0x14], edi
            //   8b83a0000000         | cmp                 dword ptr [edi], 0
            //   03c6                 | je                  0x91

        $sequence_3 = { 56 57 c745e400000000 895df4 895de0 }
            // n = 5, score = 700
            //   56                   | test                eax, eax
            //   57                   | je                  0x1ca
            //   c745e400000000       | nop                 dword ptr [eax + eax]
            //   895df4               | mov                 esi, dword ptr [eax + 0x28]
            //   895de0               | xor                 ecx, ecx

        $sequence_4 = { 8945fc 85c0 0f84c2010000 0f1f840000000000 8b7028 33c9 }
            // n = 6, score = 700
            //   8945fc               | cmp                 dword ptr [edi], 0
            //   85c0                 | je                  0x4b
            //   0f84c2010000         | test                esi, esi
            //   0f1f840000000000     | je                  0x28
            //   8b7028               | mov                 ecx, dword ptr [esi]
            //   33c9                 | test                ecx, ecx

        $sequence_5 = { 8b5b10 8b433c 8b441878 03c3 8945dc 8b7820 }
            // n = 6, score = 700
            //   8b5b10               | je                  0x10
            //   8b433c               | cmp                 eax, 0x91afca54
            //   8b441878             | je                  9
            //   03c3                 | cmp                 eax, 0xef632f2
            //   8945dc               | mov                 byte ptr [ecx - 1], al
            //   8b7820               | lea                 edx, [edx + 1]

        $sequence_6 = { 03c1 8955ec 8945e4 85d2 0f8560ffffff 8b5df0 8b7328 }
            // n = 7, score = 700
            //   03c1                 | lea                 ecx, [ecx + 1]
            //   8955ec               | dec                 ecx
            //   8945e4               | sub                 eax, 1
            //   85d2                 | inc                 ecx
            //   0f8560ffffff         | mov                 edx, dword ptr [ecx]
            //   8b5df0               | dec                 ecx
            //   8b7328               | add                 ecx, esi

        $sequence_7 = { 7403 4f ebe2 64a130000000 897df8 }
            // n = 5, score = 700
            //   7403                 | add                 eax, ebx
            //   4f                   | mov                 dword ptr [ebp - 0x20], eax
            //   ebe2                 | mov                 eax, dword ptr [ebp - 0x10]
            //   64a130000000         | add                 eax, 0xffff
            //   897df8               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_8 = { c3 803d????????00 750c c605????????01 }
            // n = 4, score = 400
            //   c3                   | ret                 
            //   803d????????00       |                     
            //   750c                 | jne                 0xe
            //   c605????????01       |                     

        $sequence_9 = { 664503de 4983c004 4983c102 664585db 75ac 4c8bb42480000000 }
            // n = 6, score = 300
            //   664503de             | inc                 ecx
            //   4983c004             | call                ebp
            //   4983c102             | dec                 eax
            //   664585db             | mov                 esi, eax
            //   75ac                 | dec                 eax
            //   4c8bb42480000000     | test                eax, eax

        $sequence_10 = { 41bb01000000 48897c2438 4c89ac2488000000 488b4818 4c8b7920 }
            // n = 5, score = 300
            //   41bb01000000         | cmp                 dword ptr [ecx + edi], 0x4550
            //   48897c2438           | je                  0x2b
            //   4c89ac2488000000     | dec                 edi
            //   488b4818             | jmp                 0xd
            //   4c8b7920             | mov                 eax, dword ptr fs:[0x30]

        $sequence_11 = { 41b9ffff0000 458d6b03 66660f1f840000000000 498b5750 33c0 450fb74748 }
            // n = 6, score = 300
            //   41b9ffff0000         | dec                 esp
            //   458d6b03             | mov                 esi, dword ptr [esp + 0x80]
            //   66660f1f840000000000     | dec    eax
            //   498b5750             | mov                 esi, eax
            //   33c0                 | dec                 eax
            //   450fb74748           | test                eax, eax

        $sequence_12 = { 48ffc2 8801 488d4901 4983e801 }
            // n = 4, score = 300
            //   48ffc2               | je                  0x76
            //   8801                 | mov                 edi, dword ptr [ebp + 0x10]
            //   488d4901             | mov                 ebx, dword ptr [ebp]
            //   4983e801             | dec                 ecx

        $sequence_13 = { 7446 4d03cf 0f1f840000000000 418b49f8 49ffca 418b11 4903ce }
            // n = 7, score = 300
            //   7446                 | jmp                 0x2d
            //   4d03cf               | je                  0x48
            //   0f1f840000000000     | dec                 ebp
            //   418b49f8             | add                 ecx, edi
            //   49ffca               | nop                 dword ptr [eax + eax]
            //   418b11               | inc                 ecx
            //   4903ce               | mov                 ecx, dword ptr [ecx - 8]

        $sequence_14 = { 418b11 4903ce 458b41fc 4903d5 4d85c0 7419 0f1f8000000000 }
            // n = 7, score = 300
            //   418b11               | add                 edi, esi
            //   4903ce               | dec                 eax
            //   458b41fc             | test                edx, edx
            //   4903d5               | jns                 0x29
            //   4d85c0               | dec                 eax
            //   7419                 | arpl                word ptr [esi + 0x3c], ax
            //   0f1f8000000000       | movzx               edx, dx

        $sequence_15 = { 488bf0 4885c0 7474 8b7d10 8b5d00 4903fe }
            // n = 6, score = 300
            //   488bf0               | je                  0xad
            //   4885c0               | nop                 dword ptr [eax + eax]
            //   7474                 | mov                 eax, dword ptr [ebx + 4]
            //   8b7d10               | test                eax, eax
            //   8b5d00               | inc                 bp
            //   4903fe               | add                 ebx, esi

        $sequence_16 = { 0f84a7000000 0f1f840000000000 8b4304 85c0 }
            // n = 4, score = 300
            //   0f84a7000000         | add                 ecx, esi
            //   0f1f840000000000     | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b4304               | dec                 ecx
            //   85c0                 | add                 ecx, esi

    condition:
        7 of them and filesize < 1015808
}