rule win_secondhandtea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.secondhandtea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.secondhandtea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? cc 4c8d0554c31400 498bd4 488bcd e8???????? 85c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   cc                   | dec                 eax
            //   4c8d0554c31400       | mov                 edi, dword ptr [esp + 0x80]
            //   498bd4               | dec                 eax
            //   488bcd               | mov                 ebx, esi
            //   e8????????           |                     
            //   85c0                 | dec                 eax

        $sequence_1 = { e8???????? 488bcf e8???????? 488b8b18100000 8b93fc070000 0fb701 3bd0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   488b8b18100000       | mov                 edx, dword ptr [ebp - 0x20]
            //   8b93fc070000         | dec                 esp
            //   0fb701               | lea                 eax, [edi + 0x540]
            //   3bd0                 | dec                 ecx

        $sequence_2 = { 753b c744242025000000 41b841000000 4c8d0d2e9b0b00 bac6000000 b90d000000 e8???????? }
            // n = 7, score = 100
            //   753b                 | lea                 eax, [ecx + 0x33]
            //   c744242025000000     | mov                 dword ptr [esp + 0x20], 0x2e
            //   41b841000000         | xor                 eax, eax
            //   4c8d0d2e9b0b00       | dec                 eax
            //   bac6000000           | add                 esp, 0x60
            //   b90d000000           | inc                 ecx
            //   e8????????           |                     

        $sequence_3 = { e8???????? 4c8b642468 448be8 4883c470 415d 5f 5e }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8b642468           | pop                 edi
            //   448be8               | ret                 
            //   4883c470             | dec                 eax
            //   415d                 | lea                 edx, [esp + 0x20]
            //   5f                   | dec                 eax
            //   5e                   | mov                 ecx, eax

        $sequence_4 = { e8???????? 8bf8 85c0 7ead 294318 7408 014314 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf8                 | inc                 ebp
            //   85c0                 | xor                 eax, eax
            //   7ead                 | inc                 ebp
            //   294318               | xor                 ecx, ecx
            //   7408                 | dec                 eax
            //   014314               | mov                 edx, dword ptr [esi + 0xf8]

        $sequence_5 = { e8???????? 4533c0 4c8d8bb4010000 418d502d 488bc8 e8???????? 488bcf }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4533c0               | mov                 eax, dword ptr [esp + 4]
            //   4c8d8bb4010000       | inc                 esp
            //   418d502d             | mov                 edx, dword ptr [esp + 0x24]
            //   488bc8               | mov                 dword ptr [esp + 0x14], ecx
            //   e8????????           |                     
            //   488bcf               | inc                 ecx

        $sequence_6 = { e9???????? 498bc9 e8???????? 488bf8 4885c0 7527 4c8d0d9d780f00 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   498bc9               | dec                 eax
            //   e8????????           |                     
            //   488bf8               | mov                 esi, edx
            //   4885c0               | dec                 eax
            //   7527                 | mov                 ebp, eax
            //   4c8d0d9d780f00       | dec                 eax

        $sequence_7 = { e8???????? 488be8 4885c0 750f 488d154fac0c00 488bcf e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488be8               | mov                 ebx, dword ptr [esp + 0x40]
            //   4885c0               | dec                 eax
            //   750f                 | mov                 esi, dword ptr [esp + 0x48]
            //   488d154fac0c00       | dec                 eax
            //   488bcf               | add                 esp, 0x30
            //   e8????????           |                     

        $sequence_8 = { e8???????? 418bc7 488b4d68 4833cd e8???????? 488b9da0000000 488bb5a8000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   418bc7               | xor                 ecx, dword ptr [ebx + ecx*4 + 0x1cd6f0]
            //   488b4d68             | dec                 eax
            //   4833cd               | mov                 dword ptr [esp + 0x20], ecx
            //   e8????????           |                     
            //   488b9da0000000       | dec                 eax
            //   488bb5a8000000       | lea                 ecx, [0xffebb225]

        $sequence_9 = { e8???????? 33c0 ebc1 ba7a000000 4c8d0d517c0a00 c744242078000000 8d4a89 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33c0                 | mov                 eax, dword ptr [eax + 0x10]
            //   ebc1                 | dec                 eax
            //   ba7a000000           | mov                 dword ptr [ecx + 0x10], eax
            //   4c8d0d517c0a00       | dec                 eax
            //   c744242078000000     | cmp                 dword ptr [ecx + 0x10], 0
            //   8d4a89               | jne                 0x357

    condition:
        7 of them and filesize < 4452352
}