rule win_sedll_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sedll."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sedll"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff75fc f30f7f45dc 6a00 6a00 6a00 }
            // n = 5, score = 200
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   f30f7f45dc           | movdqu              xmmword ptr [ebp - 0x24], xmm0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_1 = { 741e 8bd3 8d4a01 8d642400 8a02 }
            // n = 5, score = 200
            //   741e                 | je                  0x20
            //   8bd3                 | mov                 edx, ebx
            //   8d4a01               | lea                 ecx, [edx + 1]
            //   8d642400             | lea                 esp, [esp]
            //   8a02                 | mov                 al, byte ptr [edx]

        $sequence_2 = { 5e 8908 33c0 5d c20c00 8b4510 33c9 }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   8908                 | mov                 dword ptr [eax], ecx
            //   33c0                 | xor                 eax, eax
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   33c9                 | xor                 ecx, ecx

        $sequence_3 = { 8d55f8 52 c745f800000000 68???????? 8b08 50 ff11 }
            // n = 7, score = 200
            //   8d55f8               | lea                 edx, [ebp - 8]
            //   52                   | push                edx
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   68????????           |                     
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax
            //   ff11                 | call                dword ptr [ecx]

        $sequence_4 = { 7412 f30f6f05???????? 8b4520 f30f7f00 830e04 f6c101 7426 }
            // n = 7, score = 200
            //   7412                 | je                  0x14
            //   f30f6f05????????     |                     
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]
            //   f30f7f00             | movdqu              xmmword ptr [eax], xmm0
            //   830e04               | or                  dword ptr [esi], 4
            //   f6c101               | test                cl, 1
            //   7426                 | je                  0x28

        $sequence_5 = { 83c604 83ef04 73ef 8b4d08 8b4510 51 8908 }
            // n = 7, score = 200
            //   83c604               | add                 esi, 4
            //   83ef04               | sub                 edi, 4
            //   73ef                 | jae                 0xfffffff1
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   8908                 | mov                 dword ptr [eax], ecx

        $sequence_6 = { 8bf0 83c404 8975e8 85f6 7507 5f }
            // n = 6, score = 200
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   8975e8               | mov                 dword ptr [ebp - 0x18], esi
            //   85f6                 | test                esi, esi
            //   7507                 | jne                 9
            //   5f                   | pop                 edi

        $sequence_7 = { 7c7e 8d9b00000000 0fb60f 83c604 c1e902 }
            // n = 5, score = 200
            //   7c7e                 | jl                  0x80
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   0fb60f               | movzx               ecx, byte ptr [edi]
            //   83c604               | add                 esi, 4
            //   c1e902               | shr                 ecx, 2

        $sequence_8 = { 50 8b4508 03c6 50 53 ff15???????? 85c0 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   03c6                 | add                 eax, esi
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { 884e01 885602 83c603 33c9 47 3bfb }
            // n = 6, score = 200
            //   884e01               | mov                 byte ptr [esi + 1], cl
            //   885602               | mov                 byte ptr [esi + 2], dl
            //   83c603               | add                 esi, 3
            //   33c9                 | xor                 ecx, ecx
            //   47                   | inc                 edi
            //   3bfb                 | cmp                 edi, ebx

    condition:
        7 of them and filesize < 65536
}