rule win_sedreco_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sedreco."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sedreco"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 836d0804 53 56 8b750c }
            // n = 5, score = 2600
            //   51                   | push                ecx
            //   836d0804             | sub                 dword ptr [ebp + 8], 4
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]

        $sequence_1 = { 8b750c 56 e8???????? 6a08 }
            // n = 4, score = 2600
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   56                   | push                esi
            //   e8????????           |                     
            //   6a08                 | push                8

        $sequence_2 = { e8???????? 89450c 56 85c0 }
            // n = 4, score = 2600
            //   e8????????           |                     
            //   89450c               | mov                 dword ptr [ebp + 0xc], eax
            //   56                   | push                esi
            //   85c0                 | test                eax, eax

        $sequence_3 = { 55 8bec 51 836d0804 }
            // n = 4, score = 2600
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   836d0804             | sub                 dword ptr [ebp + 8], 4

        $sequence_4 = { c645ff30 e8???????? 85c0 7505 }
            // n = 4, score = 2600
            //   c645ff30             | mov                 byte ptr [ebp - 1], 0x30
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7

        $sequence_5 = { 50 68???????? 6a0d 68???????? }
            // n = 4, score = 2500
            //   50                   | push                eax
            //   68????????           |                     
            //   6a0d                 | push                0xd
            //   68????????           |                     

        $sequence_6 = { 7411 6a04 68???????? 68???????? }
            // n = 4, score = 2400
            //   7411                 | je                  0x13
            //   6a04                 | push                4
            //   68????????           |                     
            //   68????????           |                     

        $sequence_7 = { 7ce0 a1???????? 5e 85c0 }
            // n = 4, score = 2400
            //   7ce0                 | jl                  0xffffffe2
            //   a1????????           |                     
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax

        $sequence_8 = { 51 6802020000 68???????? 50 }
            // n = 4, score = 2400
            //   51                   | push                ecx
            //   6802020000           | push                0x202
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_9 = { 56 be???????? 8b06 85c0 740f 50 }
            // n = 6, score = 2200
            //   56                   | push                esi
            //   be????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   50                   | push                eax

        $sequence_10 = { ffd6 8b0d???????? 894104 85c0 }
            // n = 4, score = 2200
            //   ffd6                 | call                esi
            //   8b0d????????         |                     
            //   894104               | mov                 dword ptr [ecx + 4], eax
            //   85c0                 | test                eax, eax

        $sequence_11 = { 751d 6afe 8d45f0 50 }
            // n = 4, score = 2200
            //   751d                 | jne                 0x1f
            //   6afe                 | push                -2
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax

        $sequence_12 = { 83c40c b801000000 8b4df0 64890d00000000 59 5f }
            // n = 6, score = 2200
            //   83c40c               | add                 esp, 0xc
            //   b801000000           | mov                 eax, 1
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_13 = { 83c604 81fe???????? 7ce0 a1???????? }
            // n = 4, score = 2200
            //   83c604               | add                 esi, 4
            //   81fe????????         |                     
            //   7ce0                 | jl                  0xffffffe2
            //   a1????????           |                     

        $sequence_14 = { ffd6 8b0d???????? 898138010000 85c0 }
            // n = 4, score = 2200
            //   ffd6                 | call                esi
            //   8b0d????????         |                     
            //   898138010000         | mov                 dword ptr [ecx + 0x138], eax
            //   85c0                 | test                eax, eax

        $sequence_15 = { 488b05???????? ff90e8000000 488b0d???????? 488b05???????? ff5028 48c705????????00000000 }
            // n = 6, score = 500
            //   488b05????????       |                     
            //   ff90e8000000         | call                dword ptr [eax + 0xe8]
            //   488b0d????????       |                     
            //   488b05????????       |                     
            //   ff5028               | call                dword ptr [eax + 0x28]
            //   48c705????????00000000     |     

        $sequence_16 = { c744242004000000 4533c9 4533c0 ba000000c0 488b0d???????? 488b05???????? }
            // n = 6, score = 500
            //   c744242004000000     | inc                 ebp
            //   4533c9               | xor                 eax, eax
            //   4533c0               | dec                 eax
            //   ba000000c0           | mov                 ecx, 0x80000001
            //   488b0d????????       |                     
            //   488b05????????       |                     

        $sequence_17 = { 68???????? e8???????? 8b35???????? 83c404 6a00 }
            // n = 5, score = 500
            //   68????????           |                     
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c404               | pop                 esi
            //   6a00                 | test                eax, eax

        $sequence_18 = { 488b05???????? ff90e8000000 ba10270000 488b0d???????? 488b05???????? }
            // n = 5, score = 500
            //   488b05????????       |                     
            //   ff90e8000000         | call                dword ptr [eax + 0xe8]
            //   ba10270000           | mov                 edx, 0x2710
            //   488b0d????????       |                     
            //   488b05????????       |                     

        $sequence_19 = { 68???????? 6a00 6a00 ffd6 8b4dfc 5f }
            // n = 6, score = 500
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ffd6                 | call                esi
            //   8b4dfc               | push                -1
            //   5f                   | push                0

        $sequence_20 = { 4883c010 4883c428 c3 48890d???????? c3 48895c2410 }
            // n = 6, score = 500
            //   4883c010             | dec                 eax
            //   4883c428             | add                 eax, 0x10
            //   c3                   | dec                 eax
            //   48890d????????       |                     
            //   c3                   | add                 esp, 0x28
            //   48895c2410           | ret                 

        $sequence_21 = { 33d2 33c9 488b05???????? ff90f0000000 488905???????? }
            // n = 5, score = 500
            //   33d2                 | dec                 eax
            //   33c9                 | add                 esp, 0x28
            //   488b05????????       |                     
            //   ff90f0000000         | ret                 
            //   488905????????       |                     

        $sequence_22 = { 6800010000 6a00 68???????? e8???????? 6800020000 6a00 68???????? }
            // n = 7, score = 500
            //   6800010000           | push                eax
            //   6a00                 | push                -1
            //   68????????           |                     
            //   e8????????           |                     
            //   6800020000           | push                0
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_23 = { 488b05???????? ff90e0000000 488b0d???????? 488b05???????? ff90a8010000 }
            // n = 5, score = 500
            //   488b05????????       |                     
            //   ff90e0000000         | call                dword ptr [eax + 0xe0]
            //   488b0d????????       |                     
            //   488b05????????       |                     
            //   ff90a8010000         | call                dword ptr [eax + 0x1a8]

        $sequence_24 = { 6a00 ffd6 50 68???????? 6aff 68???????? }
            // n = 6, score = 500
            //   6a00                 | sub                 dword ptr [ebp + 8], 4
            //   ffd6                 | push                ebx
            //   50                   | push                esi
            //   68????????           |                     
            //   6aff                 | mov                 esi, dword ptr [ebp + 0xc]
            //   68????????           |                     

        $sequence_25 = { 41b906000200 4533c0 488b15???????? 48c7c101000080 488b05???????? ff9038010000 }
            // n = 6, score = 500
            //   41b906000200         | ret                 
            //   4533c0               | dec                 eax
            //   488b15????????       |                     
            //   48c7c101000080       | mov                 dword ptr [esp + 0x10], ebx
            //   488b05????????       |                     
            //   ff9038010000         | xor                 edx, edx

        $sequence_26 = { 8b442458 89442428 488b442450 4889442420 41b903000000 4533c0 488b15???????? }
            // n = 7, score = 500
            //   8b442458             | inc                 ebp
            //   89442428             | xor                 ecx, ecx
            //   488b442450           | inc                 ebp
            //   4889442420           | xor                 eax, eax
            //   41b903000000         | mov                 edx, 0xc0000000
            //   4533c0               | mov                 dword ptr [esp + 0x20], 4
            //   488b15????????       |                     

        $sequence_27 = { 7cd5 68???????? e8???????? 8b4dfc }
            // n = 4, score = 400
            //   7cd5                 | push                0x100
            //   68????????           |                     
            //   e8????????           |                     
            //   8b4dfc               | push                0

        $sequence_28 = { 8b4dfc 5f 5e 33cd b8???????? 5b }
            // n = 6, score = 400
            //   8b4dfc               | pop                 edi
            //   5f                   | add                 esp, 4
            //   5e                   | push                0
            //   33cd                 | push                -1
            //   b8????????           |                     
            //   5b                   | push                0

        $sequence_29 = { 6a0a 8d45f4 50 51 e8???????? }
            // n = 5, score = 300
            //   6a0a                 | push                -1
            //   8d45f4               | push                0
            //   50                   | push                0
            //   51                   | push                0
            //   e8????????           |                     

        $sequence_30 = { 6800000080 8d85f0fdffff 50 ff15???????? 8bf0 83feff }
            // n = 6, score = 300
            //   6800000080           | push                0
            //   8d85f0fdffff         | call                esi
            //   50                   | mov                 ecx, dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   8bf0                 | pop                 edi
            //   83feff               | push                0x100

        $sequence_31 = { 894df0 ff15???????? 8945fc 8b45f0 8945f4 8b45f4 50 }
            // n = 7, score = 200
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   50                   | push                eax

        $sequence_32 = { 57 c785ecfeffff01000000 c785e8feffffe197af54 0f6e85e8feffff }
            // n = 4, score = 200
            //   57                   | push                edi
            //   c785ecfeffff01000000     | mov    dword ptr [ebp - 0x114], 1
            //   c785e8feffffe197af54     | mov    dword ptr [ebp - 0x118], 0x54af97e1
            //   0f6e85e8feffff       | movd                mm0, dword ptr [ebp - 0x118]

        $sequence_33 = { 53 56 57 894df0 ff15???????? 8945fc }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_34 = { 8bf1 8b06 50 8b08 ff9180000000 }
            // n = 5, score = 200
            //   8bf1                 | mov                 esi, ecx
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff9180000000         | call                dword ptr [ecx + 0x80]

        $sequence_35 = { 50 ff512c 8bce 8bd8 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff512c               | call                dword ptr [ecx + 0x2c]
            //   8bce                 | mov                 ecx, esi
            //   8bd8                 | mov                 ebx, eax

        $sequence_36 = { 6aff 50 6a00 6a00 ff15???????? 5e }
            // n = 6, score = 200
            //   6aff                 | push                -1
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   5e                   | pop                 esi

        $sequence_37 = { 53 56 57 c745dce197af54 0f6e45dc 0f72f002 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   c745dce197af54       | mov                 dword ptr [ebp - 0x24], 0x54af97e1
            //   0f6e45dc             | movd                mm0, dword ptr [ebp - 0x24]
            //   0f72f002             | pslld               mm0, 2

        $sequence_38 = { 6a07 68???????? e8???????? 85c0 7402 eb0d 68e0930400 }
            // n = 7, score = 200
            //   6a07                 | push                7
            //   68????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7402                 | je                  4
            //   eb0d                 | jmp                 0xf
            //   68e0930400           | push                0x493e0

        $sequence_39 = { 52 50 8bce e8???????? 50 ffd7 85c0 }
            // n = 7, score = 100
            //   52                   | inc                 ebp
            //   50                   | xor                 eax, eax
            //   8bce                 | dec                 eax
            //   e8????????           |                     
            //   50                   | mov                 ecx, 0x80000001
            //   ffd7                 | dec                 eax
            //   85c0                 | mov                 dword ptr [esp + 0x20], eax

        $sequence_40 = { 895e30 895e2c 895e34 8bc6 5f 5e }
            // n = 6, score = 100
            //   895e30               | dec                 eax
            //   895e2c               | mov                 ecx, 0x80000001
            //   895e34               | call                dword ptr [eax + 0x138]
            //   8bc6                 | mov                 eax, dword ptr [esp + 0x58]
            //   5f                   | mov                 dword ptr [esp + 0x28], eax
            //   5e                   | dec                 eax

        $sequence_41 = { c645fc04 50 e8???????? 83c418 6a01 }
            // n = 5, score = 100
            //   c645fc04             | inc                 ecx
            //   50                   | mov                 ecx, 0x20006
            //   e8????????           |                     
            //   83c418               | inc                 ebp
            //   6a01                 | xor                 eax, eax

        $sequence_42 = { e8???????? 8b4e2c 8b5610 89442424 6aff 8d442428 6a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b4e2c               | call                dword ptr [eax + 0xe8]
            //   8b5610               | mov                 edx, 0x2710
            //   89442424             | call                dword ptr [eax + 0x10]
            //   6aff                 | call                dword ptr [eax + 0xe8]
            //   8d442428             | mov                 edx, 0x2710
            //   6a00                 | call                dword ptr [eax + 0x10]

        $sequence_43 = { fe40ff eb3d 8b742448 6a01 53 }
            // n = 5, score = 100
            //   fe40ff               | mov                 ecx, 0x20006
            //   eb3d                 | inc                 ebp
            //   8b742448             | xor                 eax, eax
            //   6a01                 | dec                 eax
            //   53                   | mov                 ecx, 0x80000001

        $sequence_44 = { 8b4c2474 8b7c2478 8944241c 56 89442424 6a01 }
            // n = 6, score = 100
            //   8b4c2474             | ret                 
            //   8b7c2478             | ret                 
            //   8944241c             | dec                 eax
            //   56                   | mov                 dword ptr [esp + 0x10], ebx
            //   89442424             | dec                 eax
            //   6a01                 | mov                 dword ptr [esp + 0x18], esi

        $sequence_45 = { 8bf0 8b442414 85c0 7505 a1???????? }
            // n = 5, score = 100
            //   8bf0                 | call                dword ptr [eax + 0xe8]
            //   8b442414             | mov                 edx, 0x2710
            //   85c0                 | dec                 eax
            //   7505                 | add                 esp, 0x28
            //   a1????????           |                     

        $sequence_46 = { ff15???????? 85c0 894604 7522 8d4de4 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   85c0                 | mov                 edx, 0x80000000
            //   894604               | dec                 eax
            //   7522                 | mov                 dword ptr [esp + 0x20], eax
            //   8d4de4               | inc                 ecx

    condition:
        7 of them and filesize < 1586176
}