rule win_seduploader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.seduploader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.seduploader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff763c e8???????? 83c40c 3b4508 }
            // n = 4, score = 2400
            //   ff763c               | push                dword ptr [esi + 0x3c]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   3b4508               | cmp                 eax, dword ptr [ebp + 8]

        $sequence_1 = { 50 e8???????? 8b4510 83c6fe 8930 8d4601 50 }
            // n = 7, score = 2400
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi
            //   8d4601               | lea                 eax, [esi + 1]
            //   50                   | push                eax

        $sequence_2 = { 8b4510 83c6fe 8930 8d4601 50 e8???????? }
            // n = 6, score = 2400
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi
            //   8d4601               | lea                 eax, [esi + 1]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 83c6fe 8930 8d4601 50 e8???????? }
            // n = 5, score = 2400
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi
            //   8d4601               | lea                 eax, [esi + 1]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_4 = { 8b4510 83c6fe 8930 8d4601 }
            // n = 4, score = 2400
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi
            //   8d4601               | lea                 eax, [esi + 1]

        $sequence_5 = { e8???????? 8b4510 83c6fe 8930 8d4601 }
            // n = 5, score = 2400
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi
            //   8d4601               | lea                 eax, [esi + 1]

        $sequence_6 = { 56 6a3e 8bf1 e8???????? }
            // n = 4, score = 2400
            //   56                   | push                esi
            //   6a3e                 | push                0x3e
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     

        $sequence_7 = { 8b4510 83c6fe 8930 8d4601 50 }
            // n = 5, score = 2400
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi
            //   8d4601               | lea                 eax, [esi + 1]
            //   50                   | push                eax

        $sequence_8 = { 50 e8???????? 8b4510 83c6fe 8930 }
            // n = 5, score = 2400
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi

        $sequence_9 = { 83c6fe 8930 8d4601 50 }
            // n = 4, score = 2400
            //   83c6fe               | add                 esi, -2
            //   8930                 | mov                 dword ptr [eax], esi
            //   8d4601               | lea                 eax, [esi + 1]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 401408
}